from chardet.enums import CharacterCategory, SequenceLikelihood
from chardet.sbcharsetprober import SingleByteCharSetModel

NORWEGIAN_LANG_MODEL = {
    27: {  # 'A'
        27: SequenceLikelihood.UNLIKELY,  # 'A'
        35: SequenceLikelihood.LIKELY,  # 'B'
        44: SequenceLikelihood.LIKELY,  # 'C'
        25: SequenceLikelihood.LIKELY,  # 'D'
        30: SequenceLikelihood.UNLIKELY,  # 'E'
        34: SequenceLikelihood.LIKELY,  # 'F'
        43: SequenceLikelihood.LIKELY,  # 'G'
        29: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.LIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        38: SequenceLikelihood.LIKELY,  # 'K'
        40: SequenceLikelihood.LIKELY,  # 'L'
        32: SequenceLikelihood.LIKELY,  # 'M'
        28: SequenceLikelihood.LIKELY,  # 'N'
        42: SequenceLikelihood.UNLIKELY,  # 'O'
        39: SequenceLikelihood.LIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.LIKELY,  # 'R'
        24: SequenceLikelihood.POSITIVE,  # 'S'
        33: SequenceLikelihood.LIKELY,  # 'T'
        47: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.LIKELY,  # 'V'
        49: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        7: SequenceLikelihood.LIKELY,  # 'a'
        19: SequenceLikelihood.LIKELY,  # 'b'
        26: SequenceLikelihood.LIKELY,  # 'c'
        10: SequenceLikelihood.LIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        16: SequenceLikelihood.LIKELY,  # 'f'
        11: SequenceLikelihood.LIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.LIKELY,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        12: SequenceLikelihood.LIKELY,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.LIKELY,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        9: SequenceLikelihood.UNLIKELY,  # 'o'
        15: SequenceLikelihood.LIKELY,  # 'p'
        55: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.POSITIVE,  # 'r'
        6: SequenceLikelihood.LIKELY,  # 's'
        3: SequenceLikelihood.LIKELY,  # 't'
        17: SequenceLikelihood.LIKELY,  # 'u'
        14: SequenceLikelihood.POSITIVE,  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'w'
        48: SequenceLikelihood.UNLIKELY,  # 'x'
        23: SequenceLikelihood.UNLIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        51: SequenceLikelihood.UNLIKELY,  # 'Å'
        58: SequenceLikelihood.NEGATIVE,  # 'Æ'
        52: SequenceLikelihood.UNLIKELY,  # 'Ø'
        18: SequenceLikelihood.UNLIKELY,  # 'å'
        31: SequenceLikelihood.UNLIKELY,  # 'æ'
        22: SequenceLikelihood.NEGATIVE,  # 'ø'
    },
    35: {  # 'B'
        27: SequenceLikelihood.LIKELY,  # 'A'
        35: SequenceLikelihood.LIKELY,  # 'B'
        44: SequenceLikelihood.LIKELY,  # 'C'
        25: SequenceLikelihood.UNLIKELY,  # 'D'
        30: SequenceLikelihood.LIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        29: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.LIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        38: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.LIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        28: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.LIKELY,  # 'O'
        39: SequenceLikelihood.UNLIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.LIKELY,  # 'R'
        24: SequenceLikelihood.LIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        47: SequenceLikelihood.LIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        49: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        7: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        26: SequenceLikelihood.UNLIKELY,  # 'c'
        10: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        16: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.POSITIVE,  # 'i'
        21: SequenceLikelihood.LIKELY,  # 'j'
        12: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        55: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.POSITIVE,  # 'r'
        6: SequenceLikelihood.UNLIKELY,  # 's'
        3: SequenceLikelihood.UNLIKELY,  # 't'
        17: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'w'
        48: SequenceLikelihood.UNLIKELY,  # 'x'
        23: SequenceLikelihood.LIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        51: SequenceLikelihood.UNLIKELY,  # 'Å'
        58: SequenceLikelihood.UNLIKELY,  # 'Æ'
        52: SequenceLikelihood.UNLIKELY,  # 'Ø'
        18: SequenceLikelihood.LIKELY,  # 'å'
        31: SequenceLikelihood.LIKELY,  # 'æ'
        22: SequenceLikelihood.LIKELY,  # 'ø'
    },
    44: {  # 'C'
        27: SequenceLikelihood.LIKELY,  # 'A'
        35: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.LIKELY,  # 'C'
        25: SequenceLikelihood.LIKELY,  # 'D'
        30: SequenceLikelihood.LIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        29: SequenceLikelihood.LIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        38: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        28: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.LIKELY,  # 'O'
        39: SequenceLikelihood.UNLIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        24: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        47: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        49: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        7: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        26: SequenceLikelihood.UNLIKELY,  # 'c'
        10: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.LIKELY,  # 'e'
        16: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.POSITIVE,  # 'h'
        5: SequenceLikelihood.LIKELY,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        12: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.LIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        55: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.LIKELY,  # 'r'
        6: SequenceLikelihood.UNLIKELY,  # 's'
        3: SequenceLikelihood.UNLIKELY,  # 't'
        17: SequenceLikelihood.LIKELY,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'w'
        48: SequenceLikelihood.UNLIKELY,  # 'x'
        23: SequenceLikelihood.UNLIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        51: SequenceLikelihood.NEGATIVE,  # 'Å'
        58: SequenceLikelihood.NEGATIVE,  # 'Æ'
        52: SequenceLikelihood.NEGATIVE,  # 'Ø'
        18: SequenceLikelihood.UNLIKELY,  # 'å'
        31: SequenceLikelihood.UNLIKELY,  # 'æ'
        22: SequenceLikelihood.UNLIKELY,  # 'ø'
    },
    25: {  # 'D'
        27: SequenceLikelihood.LIKELY,  # 'A'
        35: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        25: SequenceLikelihood.UNLIKELY,  # 'D'
        30: SequenceLikelihood.LIKELY,  # 'E'
        34: SequenceLikelihood.LIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        29: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.LIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        38: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.LIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        28: SequenceLikelihood.LIKELY,  # 'N'
        42: SequenceLikelihood.LIKELY,  # 'O'
        39: SequenceLikelihood.UNLIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.LIKELY,  # 'R'
        24: SequenceLikelihood.LIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        47: SequenceLikelihood.LIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        49: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        7: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        26: SequenceLikelihood.UNLIKELY,  # 'c'
        10: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        16: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.POSITIVE,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        12: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        9: SequenceLikelihood.LIKELY,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        55: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.LIKELY,  # 'r'
        6: SequenceLikelihood.UNLIKELY,  # 's'
        3: SequenceLikelihood.UNLIKELY,  # 't'
        17: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'w'
        48: SequenceLikelihood.UNLIKELY,  # 'x'
        23: SequenceLikelihood.LIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        51: SequenceLikelihood.UNLIKELY,  # 'Å'
        58: SequenceLikelihood.UNLIKELY,  # 'Æ'
        52: SequenceLikelihood.UNLIKELY,  # 'Ø'
        18: SequenceLikelihood.UNLIKELY,  # 'å'
        31: SequenceLikelihood.UNLIKELY,  # 'æ'
        22: SequenceLikelihood.LIKELY,  # 'ø'
    },
    30: {  # 'E'
        27: SequenceLikelihood.LIKELY,  # 'A'
        35: SequenceLikelihood.LIKELY,  # 'B'
        44: SequenceLikelihood.LIKELY,  # 'C'
        25: SequenceLikelihood.LIKELY,  # 'D'
        30: SequenceLikelihood.UNLIKELY,  # 'E'
        34: SequenceLikelihood.LIKELY,  # 'F'
        43: SequenceLikelihood.LIKELY,  # 'G'
        29: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.LIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        38: SequenceLikelihood.LIKELY,  # 'K'
        40: SequenceLikelihood.LIKELY,  # 'L'
        32: SequenceLikelihood.LIKELY,  # 'M'
        28: SequenceLikelihood.POSITIVE,  # 'N'
        42: SequenceLikelihood.LIKELY,  # 'O'
        39: SequenceLikelihood.LIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.POSITIVE,  # 'R'
        24: SequenceLikelihood.LIKELY,  # 'S'
        33: SequenceLikelihood.LIKELY,  # 'T'
        47: SequenceLikelihood.LIKELY,  # 'U'
        37: SequenceLikelihood.LIKELY,  # 'V'
        49: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        7: SequenceLikelihood.LIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        26: SequenceLikelihood.LIKELY,  # 'c'
        10: SequenceLikelihood.LIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        16: SequenceLikelihood.LIKELY,  # 'f'
        11: SequenceLikelihood.LIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.LIKELY,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        12: SequenceLikelihood.LIKELY,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.LIKELY,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        9: SequenceLikelihood.UNLIKELY,  # 'o'
        15: SequenceLikelihood.LIKELY,  # 'p'
        55: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.POSITIVE,  # 'r'
        6: SequenceLikelihood.LIKELY,  # 's'
        3: SequenceLikelihood.POSITIVE,  # 't'
        17: SequenceLikelihood.LIKELY,  # 'u'
        14: SequenceLikelihood.LIKELY,  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'w'
        48: SequenceLikelihood.LIKELY,  # 'x'
        23: SequenceLikelihood.UNLIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        51: SequenceLikelihood.UNLIKELY,  # 'Å'
        58: SequenceLikelihood.UNLIKELY,  # 'Æ'
        52: SequenceLikelihood.UNLIKELY,  # 'Ø'
        18: SequenceLikelihood.NEGATIVE,  # 'å'
        31: SequenceLikelihood.NEGATIVE,  # 'æ'
        22: SequenceLikelihood.UNLIKELY,  # 'ø'
    },
    34: {  # 'F'
        27: SequenceLikelihood.LIKELY,  # 'A'
        35: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        25: SequenceLikelihood.UNLIKELY,  # 'D'
        30: SequenceLikelihood.LIKELY,  # 'E'
        34: SequenceLikelihood.LIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        29: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.LIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        38: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        28: SequenceLikelihood.LIKELY,  # 'N'
        42: SequenceLikelihood.LIKELY,  # 'O'
        39: SequenceLikelihood.UNLIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.LIKELY,  # 'R'
        24: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.LIKELY,  # 'T'
        47: SequenceLikelihood.LIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        49: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        7: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        26: SequenceLikelihood.UNLIKELY,  # 'c'
        10: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.LIKELY,  # 'e'
        16: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.POSITIVE,  # 'i'
        21: SequenceLikelihood.LIKELY,  # 'j'
        12: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        55: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.POSITIVE,  # 'r'
        6: SequenceLikelihood.UNLIKELY,  # 's'
        3: SequenceLikelihood.UNLIKELY,  # 't'
        17: SequenceLikelihood.LIKELY,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'w'
        48: SequenceLikelihood.UNLIKELY,  # 'x'
        23: SequenceLikelihood.LIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        51: SequenceLikelihood.UNLIKELY,  # 'Å'
        58: SequenceLikelihood.UNLIKELY,  # 'Æ'
        52: SequenceLikelihood.UNLIKELY,  # 'Ø'
        18: SequenceLikelihood.LIKELY,  # 'å'
        31: SequenceLikelihood.UNLIKELY,  # 'æ'
        22: SequenceLikelihood.POSITIVE,  # 'ø'
    },
    43: {  # 'G'
        27: SequenceLikelihood.LIKELY,  # 'A'
        35: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        25: SequenceLikelihood.UNLIKELY,  # 'D'
        30: SequenceLikelihood.LIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        29: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.LIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        38: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        28: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.LIKELY,  # 'O'
        39: SequenceLikelihood.LIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.LIKELY,  # 'R'
        24: SequenceLikelihood.LIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        47: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        49: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        7: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        26: SequenceLikelihood.UNLIKELY,  # 'c'
        10: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.LIKELY,  # 'e'
        16: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.LIKELY,  # 'i'
        21: SequenceLikelihood.LIKELY,  # 'j'
        12: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.LIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        55: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.POSITIVE,  # 'r'
        6: SequenceLikelihood.UNLIKELY,  # 's'
        3: SequenceLikelihood.UNLIKELY,  # 't'
        17: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'w'
        48: SequenceLikelihood.UNLIKELY,  # 'x'
        23: SequenceLikelihood.UNLIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        51: SequenceLikelihood.UNLIKELY,  # 'Å'
        58: SequenceLikelihood.UNLIKELY,  # 'Æ'
        52: SequenceLikelihood.UNLIKELY,  # 'Ø'
        18: SequenceLikelihood.LIKELY,  # 'å'
        31: SequenceLikelihood.UNLIKELY,  # 'æ'
        22: SequenceLikelihood.UNLIKELY,  # 'ø'
    },
    29: {  # 'H'
        27: SequenceLikelihood.LIKELY,  # 'A'
        35: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        25: SequenceLikelihood.LIKELY,  # 'D'
        30: SequenceLikelihood.LIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        29: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.LIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        38: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        28: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.LIKELY,  # 'O'
        39: SequenceLikelihood.UNLIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        24: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        47: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        49: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        7: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        26: SequenceLikelihood.UNLIKELY,  # 'c'
        10: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        16: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.LIKELY,  # 'i'
        21: SequenceLikelihood.LIKELY,  # 'j'
        12: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        55: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.UNLIKELY,  # 'r'
        6: SequenceLikelihood.UNLIKELY,  # 's'
        3: SequenceLikelihood.UNLIKELY,  # 't'
        17: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.POSITIVE,  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'w'
        48: SequenceLikelihood.UNLIKELY,  # 'x'
        23: SequenceLikelihood.LIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        51: SequenceLikelihood.UNLIKELY,  # 'Å'
        58: SequenceLikelihood.UNLIKELY,  # 'Æ'
        52: SequenceLikelihood.UNLIKELY,  # 'Ø'
        18: SequenceLikelihood.LIKELY,  # 'å'
        31: SequenceLikelihood.UNLIKELY,  # 'æ'
        22: SequenceLikelihood.LIKELY,  # 'ø'
    },
    36: {  # 'I'
        27: SequenceLikelihood.LIKELY,  # 'A'
        35: SequenceLikelihood.LIKELY,  # 'B'
        44: SequenceLikelihood.LIKELY,  # 'C'
        25: SequenceLikelihood.LIKELY,  # 'D'
        30: SequenceLikelihood.LIKELY,  # 'E'
        34: SequenceLikelihood.LIKELY,  # 'F'
        43: SequenceLikelihood.LIKELY,  # 'G'
        29: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.LIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        38: SequenceLikelihood.LIKELY,  # 'K'
        40: SequenceLikelihood.LIKELY,  # 'L'
        32: SequenceLikelihood.LIKELY,  # 'M'
        28: SequenceLikelihood.POSITIVE,  # 'N'
        42: SequenceLikelihood.LIKELY,  # 'O'
        39: SequenceLikelihood.LIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.LIKELY,  # 'R'
        24: SequenceLikelihood.LIKELY,  # 'S'
        33: SequenceLikelihood.LIKELY,  # 'T'
        47: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.LIKELY,  # 'V'
        49: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        7: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        26: SequenceLikelihood.UNLIKELY,  # 'c'
        10: SequenceLikelihood.LIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        16: SequenceLikelihood.LIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.UNLIKELY,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        12: SequenceLikelihood.LIKELY,  # 'k'
        8: SequenceLikelihood.LIKELY,  # 'l'
        13: SequenceLikelihood.LIKELY,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        9: SequenceLikelihood.UNLIKELY,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        55: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.LIKELY,  # 'r'
        6: SequenceLikelihood.LIKELY,  # 's'
        3: SequenceLikelihood.LIKELY,  # 't'
        17: SequenceLikelihood.UNLIKELY,  # 'u'
        14: SequenceLikelihood.LIKELY,  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'w'
        48: SequenceLikelihood.UNLIKELY,  # 'x'
        23: SequenceLikelihood.UNLIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        51: SequenceLikelihood.UNLIKELY,  # 'Å'
        58: SequenceLikelihood.UNLIKELY,  # 'Æ'
        52: SequenceLikelihood.UNLIKELY,  # 'Ø'
        18: SequenceLikelihood.UNLIKELY,  # 'å'
        31: SequenceLikelihood.NEGATIVE,  # 'æ'
        22: SequenceLikelihood.UNLIKELY,  # 'ø'
    },
    45: {  # 'J'
        27: SequenceLikelihood.UNLIKELY,  # 'A'
        35: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        25: SequenceLikelihood.UNLIKELY,  # 'D'
        30: SequenceLikelihood.LIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        29: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        38: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        28: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.LIKELY,  # 'O'
        39: SequenceLikelihood.UNLIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        24: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        47: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        49: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        7: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        26: SequenceLikelihood.UNLIKELY,  # 'c'
        10: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        16: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.UNLIKELY,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        12: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        55: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.UNLIKELY,  # 'r'
        6: SequenceLikelihood.UNLIKELY,  # 's'
        3: SequenceLikelihood.UNLIKELY,  # 't'
        17: SequenceLikelihood.LIKELY,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'w'
        48: SequenceLikelihood.UNLIKELY,  # 'x'
        23: SequenceLikelihood.UNLIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        51: SequenceLikelihood.UNLIKELY,  # 'Å'
        58: SequenceLikelihood.UNLIKELY,  # 'Æ'
        52: SequenceLikelihood.UNLIKELY,  # 'Ø'
        18: SequenceLikelihood.UNLIKELY,  # 'å'
        31: SequenceLikelihood.UNLIKELY,  # 'æ'
        22: SequenceLikelihood.LIKELY,  # 'ø'
    },
    38: {  # 'K'
        27: SequenceLikelihood.LIKELY,  # 'A'
        35: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        25: SequenceLikelihood.UNLIKELY,  # 'D'
        30: SequenceLikelihood.LIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        29: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.LIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        38: SequenceLikelihood.LIKELY,  # 'K'
        40: SequenceLikelihood.LIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        28: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.LIKELY,  # 'O'
        39: SequenceLikelihood.UNLIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.LIKELY,  # 'R'
        24: SequenceLikelihood.LIKELY,  # 'S'
        33: SequenceLikelihood.LIKELY,  # 'T'
        47: SequenceLikelihood.LIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        49: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        7: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        26: SequenceLikelihood.UNLIKELY,  # 'c'
        10: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.LIKELY,  # 'e'
        16: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.POSITIVE,  # 'i'
        21: SequenceLikelihood.POSITIVE,  # 'j'
        12: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.LIKELY,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        55: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.POSITIVE,  # 'r'
        6: SequenceLikelihood.UNLIKELY,  # 's'
        3: SequenceLikelihood.UNLIKELY,  # 't'
        17: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.LIKELY,  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'w'
        48: SequenceLikelihood.UNLIKELY,  # 'x'
        23: SequenceLikelihood.LIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        51: SequenceLikelihood.UNLIKELY,  # 'Å'
        58: SequenceLikelihood.NEGATIVE,  # 'Æ'
        52: SequenceLikelihood.UNLIKELY,  # 'Ø'
        18: SequenceLikelihood.UNLIKELY,  # 'å'
        31: SequenceLikelihood.UNLIKELY,  # 'æ'
        22: SequenceLikelihood.UNLIKELY,  # 'ø'
    },
    40: {  # 'L'
        27: SequenceLikelihood.LIKELY,  # 'A'
        35: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        25: SequenceLikelihood.LIKELY,  # 'D'
        30: SequenceLikelihood.LIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        29: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.LIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        38: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.LIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        28: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.LIKELY,  # 'O'
        39: SequenceLikelihood.UNLIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        24: SequenceLikelihood.LIKELY,  # 'S'
        33: SequenceLikelihood.LIKELY,  # 'T'
        47: SequenceLikelihood.LIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        49: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        7: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        26: SequenceLikelihood.UNLIKELY,  # 'c'
        10: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        16: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.POSITIVE,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        12: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        55: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.UNLIKELY,  # 'r'
        6: SequenceLikelihood.UNLIKELY,  # 's'
        3: SequenceLikelihood.UNLIKELY,  # 't'
        17: SequenceLikelihood.LIKELY,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'w'
        48: SequenceLikelihood.UNLIKELY,  # 'x'
        23: SequenceLikelihood.LIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        51: SequenceLikelihood.UNLIKELY,  # 'Å'
        58: SequenceLikelihood.UNLIKELY,  # 'Æ'
        52: SequenceLikelihood.UNLIKELY,  # 'Ø'
        18: SequenceLikelihood.UNLIKELY,  # 'å'
        31: SequenceLikelihood.LIKELY,  # 'æ'
        22: SequenceLikelihood.LIKELY,  # 'ø'
    },
    32: {  # 'M'
        27: SequenceLikelihood.LIKELY,  # 'A'
        35: SequenceLikelihood.LIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        25: SequenceLikelihood.LIKELY,  # 'D'
        30: SequenceLikelihood.LIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        29: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.LIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        38: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.LIKELY,  # 'M'
        28: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.LIKELY,  # 'O'
        39: SequenceLikelihood.LIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        24: SequenceLikelihood.LIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        47: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        49: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        7: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        26: SequenceLikelihood.UNLIKELY,  # 'c'
        10: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        16: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.POSITIVE,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        12: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        55: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.UNLIKELY,  # 'r'
        6: SequenceLikelihood.UNLIKELY,  # 's'
        3: SequenceLikelihood.UNLIKELY,  # 't'
        17: SequenceLikelihood.LIKELY,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'w'
        48: SequenceLikelihood.UNLIKELY,  # 'x'
        23: SequenceLikelihood.LIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        51: SequenceLikelihood.UNLIKELY,  # 'Å'
        58: SequenceLikelihood.UNLIKELY,  # 'Æ'
        52: SequenceLikelihood.UNLIKELY,  # 'Ø'
        18: SequenceLikelihood.LIKELY,  # 'å'
        31: SequenceLikelihood.UNLIKELY,  # 'æ'
        22: SequenceLikelihood.LIKELY,  # 'ø'
    },
    28: {  # 'N'
        27: SequenceLikelihood.LIKELY,  # 'A'
        35: SequenceLikelihood.LIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        25: SequenceLikelihood.LIKELY,  # 'D'
        30: SequenceLikelihood.LIKELY,  # 'E'
        34: SequenceLikelihood.LIKELY,  # 'F'
        43: SequenceLikelihood.LIKELY,  # 'G'
        29: SequenceLikelihood.LIKELY,  # 'H'
        36: SequenceLikelihood.LIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        38: SequenceLikelihood.LIKELY,  # 'K'
        40: SequenceLikelihood.LIKELY,  # 'L'
        32: SequenceLikelihood.LIKELY,  # 'M'
        28: SequenceLikelihood.LIKELY,  # 'N'
        42: SequenceLikelihood.LIKELY,  # 'O'
        39: SequenceLikelihood.UNLIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.LIKELY,  # 'R'
        24: SequenceLikelihood.LIKELY,  # 'S'
        33: SequenceLikelihood.LIKELY,  # 'T'
        47: SequenceLikelihood.LIKELY,  # 'U'
        37: SequenceLikelihood.LIKELY,  # 'V'
        49: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.LIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        7: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        26: SequenceLikelihood.UNLIKELY,  # 'c'
        10: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        16: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.LIKELY,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        12: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        55: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.LIKELY,  # 'r'
        6: SequenceLikelihood.UNLIKELY,  # 's'
        3: SequenceLikelihood.UNLIKELY,  # 't'
        17: SequenceLikelihood.LIKELY,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'w'
        48: SequenceLikelihood.UNLIKELY,  # 'x'
        23: SequenceLikelihood.POSITIVE,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        51: SequenceLikelihood.UNLIKELY,  # 'Å'
        58: SequenceLikelihood.UNLIKELY,  # 'Æ'
        52: SequenceLikelihood.UNLIKELY,  # 'Ø'
        18: SequenceLikelihood.POSITIVE,  # 'å'
        31: SequenceLikelihood.LIKELY,  # 'æ'
        22: SequenceLikelihood.LIKELY,  # 'ø'
    },
    42: {  # 'O'
        27: SequenceLikelihood.UNLIKELY,  # 'A'
        35: SequenceLikelihood.LIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        25: SequenceLikelihood.LIKELY,  # 'D'
        30: SequenceLikelihood.UNLIKELY,  # 'E'
        34: SequenceLikelihood.LIKELY,  # 'F'
        43: SequenceLikelihood.LIKELY,  # 'G'
        29: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        38: SequenceLikelihood.LIKELY,  # 'K'
        40: SequenceLikelihood.LIKELY,  # 'L'
        32: SequenceLikelihood.LIKELY,  # 'M'
        28: SequenceLikelihood.LIKELY,  # 'N'
        42: SequenceLikelihood.UNLIKELY,  # 'O'
        39: SequenceLikelihood.LIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.LIKELY,  # 'R'
        24: SequenceLikelihood.LIKELY,  # 'S'
        33: SequenceLikelihood.LIKELY,  # 'T'
        47: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.LIKELY,  # 'V'
        49: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        7: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.LIKELY,  # 'b'
        26: SequenceLikelihood.LIKELY,  # 'c'
        10: SequenceLikelihood.LIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        16: SequenceLikelihood.LIKELY,  # 'f'
        11: SequenceLikelihood.POSITIVE,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.UNLIKELY,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        12: SequenceLikelihood.LIKELY,  # 'k'
        8: SequenceLikelihood.LIKELY,  # 'l'
        13: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.LIKELY,  # 'n'
        9: SequenceLikelihood.UNLIKELY,  # 'o'
        15: SequenceLikelihood.POSITIVE,  # 'p'
        55: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.LIKELY,  # 'r'
        6: SequenceLikelihood.POSITIVE,  # 's'
        3: SequenceLikelihood.LIKELY,  # 't'
        17: SequenceLikelihood.LIKELY,  # 'u'
        14: SequenceLikelihood.LIKELY,  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'w'
        48: SequenceLikelihood.UNLIKELY,  # 'x'
        23: SequenceLikelihood.UNLIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        51: SequenceLikelihood.UNLIKELY,  # 'Å'
        58: SequenceLikelihood.NEGATIVE,  # 'Æ'
        52: SequenceLikelihood.UNLIKELY,  # 'Ø'
        18: SequenceLikelihood.UNLIKELY,  # 'å'
        31: SequenceLikelihood.NEGATIVE,  # 'æ'
        22: SequenceLikelihood.UNLIKELY,  # 'ø'
    },
    39: {  # 'P'
        27: SequenceLikelihood.LIKELY,  # 'A'
        35: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.LIKELY,  # 'C'
        25: SequenceLikelihood.LIKELY,  # 'D'
        30: SequenceLikelihood.LIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        29: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.LIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        38: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.LIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        28: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.LIKELY,  # 'O'
        39: SequenceLikelihood.LIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.LIKELY,  # 'R'
        24: SequenceLikelihood.LIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        47: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        49: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        7: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        26: SequenceLikelihood.UNLIKELY,  # 'c'
        10: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        16: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.LIKELY,  # 'h'
        5: SequenceLikelihood.LIKELY,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        12: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.LIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        55: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.POSITIVE,  # 'r'
        6: SequenceLikelihood.LIKELY,  # 's'
        3: SequenceLikelihood.UNLIKELY,  # 't'
        17: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'w'
        48: SequenceLikelihood.UNLIKELY,  # 'x'
        23: SequenceLikelihood.UNLIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        51: SequenceLikelihood.LIKELY,  # 'Å'
        58: SequenceLikelihood.UNLIKELY,  # 'Æ'
        52: SequenceLikelihood.UNLIKELY,  # 'Ø'
        18: SequenceLikelihood.POSITIVE,  # 'å'
        31: SequenceLikelihood.UNLIKELY,  # 'æ'
        22: SequenceLikelihood.UNLIKELY,  # 'ø'
    },
    57: {  # 'Q'
        27: SequenceLikelihood.UNLIKELY,  # 'A'
        35: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        25: SequenceLikelihood.UNLIKELY,  # 'D'
        30: SequenceLikelihood.UNLIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        29: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        38: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        28: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.UNLIKELY,  # 'O'
        39: SequenceLikelihood.UNLIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        24: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        47: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        49: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        7: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        26: SequenceLikelihood.UNLIKELY,  # 'c'
        10: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        16: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.UNLIKELY,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        12: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        9: SequenceLikelihood.UNLIKELY,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        55: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.UNLIKELY,  # 'r'
        6: SequenceLikelihood.UNLIKELY,  # 's'
        3: SequenceLikelihood.UNLIKELY,  # 't'
        17: SequenceLikelihood.LIKELY,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'w'
        48: SequenceLikelihood.UNLIKELY,  # 'x'
        23: SequenceLikelihood.UNLIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        51: SequenceLikelihood.NEGATIVE,  # 'Å'
        58: SequenceLikelihood.NEGATIVE,  # 'Æ'
        52: SequenceLikelihood.NEGATIVE,  # 'Ø'
        18: SequenceLikelihood.NEGATIVE,  # 'å'
        31: SequenceLikelihood.NEGATIVE,  # 'æ'
        22: SequenceLikelihood.NEGATIVE,  # 'ø'
    },
    41: {  # 'R'
        27: SequenceLikelihood.LIKELY,  # 'A'
        35: SequenceLikelihood.LIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        25: SequenceLikelihood.LIKELY,  # 'D'
        30: SequenceLikelihood.LIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.LIKELY,  # 'G'
        29: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.LIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        38: SequenceLikelihood.LIKELY,  # 'K'
        40: SequenceLikelihood.LIKELY,  # 'L'
        32: SequenceLikelihood.LIKELY,  # 'M'
        28: SequenceLikelihood.LIKELY,  # 'N'
        42: SequenceLikelihood.LIKELY,  # 'O'
        39: SequenceLikelihood.UNLIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        24: SequenceLikelihood.LIKELY,  # 'S'
        33: SequenceLikelihood.LIKELY,  # 'T'
        47: SequenceLikelihood.LIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        49: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        7: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        26: SequenceLikelihood.UNLIKELY,  # 'c'
        10: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        16: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.POSITIVE,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        12: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        55: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.UNLIKELY,  # 'r'
        6: SequenceLikelihood.UNLIKELY,  # 's'
        3: SequenceLikelihood.UNLIKELY,  # 't'
        17: SequenceLikelihood.LIKELY,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'w'
        48: SequenceLikelihood.UNLIKELY,  # 'x'
        23: SequenceLikelihood.LIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        51: SequenceLikelihood.UNLIKELY,  # 'Å'
        58: SequenceLikelihood.UNLIKELY,  # 'Æ'
        52: SequenceLikelihood.UNLIKELY,  # 'Ø'
        18: SequenceLikelihood.LIKELY,  # 'å'
        31: SequenceLikelihood.UNLIKELY,  # 'æ'
        22: SequenceLikelihood.LIKELY,  # 'ø'
    },
    24: {  # 'S'
        27: SequenceLikelihood.POSITIVE,  # 'A'
        35: SequenceLikelihood.LIKELY,  # 'B'
        44: SequenceLikelihood.LIKELY,  # 'C'
        25: SequenceLikelihood.LIKELY,  # 'D'
        30: SequenceLikelihood.LIKELY,  # 'E'
        34: SequenceLikelihood.LIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        29: SequenceLikelihood.LIKELY,  # 'H'
        36: SequenceLikelihood.LIKELY,  # 'I'
        45: SequenceLikelihood.LIKELY,  # 'J'
        38: SequenceLikelihood.LIKELY,  # 'K'
        40: SequenceLikelihood.LIKELY,  # 'L'
        32: SequenceLikelihood.LIKELY,  # 'M'
        28: SequenceLikelihood.LIKELY,  # 'N'
        42: SequenceLikelihood.LIKELY,  # 'O'
        39: SequenceLikelihood.LIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        24: SequenceLikelihood.LIKELY,  # 'S'
        33: SequenceLikelihood.LIKELY,  # 'T'
        47: SequenceLikelihood.LIKELY,  # 'U'
        37: SequenceLikelihood.LIKELY,  # 'V'
        49: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        7: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        26: SequenceLikelihood.LIKELY,  # 'c'
        10: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        16: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.LIKELY,  # 'h'
        5: SequenceLikelihood.POSITIVE,  # 'i'
        21: SequenceLikelihood.LIKELY,  # 'j'
        12: SequenceLikelihood.POSITIVE,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.LIKELY,  # 'm'
        4: SequenceLikelihood.LIKELY,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.POSITIVE,  # 'p'
        55: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.UNLIKELY,  # 'r'
        6: SequenceLikelihood.UNLIKELY,  # 's'
        3: SequenceLikelihood.POSITIVE,  # 't'
        17: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.POSITIVE,  # 'v'
        46: SequenceLikelihood.LIKELY,  # 'w'
        48: SequenceLikelihood.UNLIKELY,  # 'x'
        23: SequenceLikelihood.LIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        51: SequenceLikelihood.LIKELY,  # 'Å'
        58: SequenceLikelihood.UNLIKELY,  # 'Æ'
        52: SequenceLikelihood.UNLIKELY,  # 'Ø'
        18: SequenceLikelihood.POSITIVE,  # 'å'
        31: SequenceLikelihood.LIKELY,  # 'æ'
        22: SequenceLikelihood.POSITIVE,  # 'ø'
    },
    33: {  # 'T'
        27: SequenceLikelihood.LIKELY,  # 'A'
        35: SequenceLikelihood.LIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        25: SequenceLikelihood.UNLIKELY,  # 'D'
        30: SequenceLikelihood.POSITIVE,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        29: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.LIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        38: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        28: SequenceLikelihood.LIKELY,  # 'N'
        42: SequenceLikelihood.LIKELY,  # 'O'
        39: SequenceLikelihood.UNLIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.LIKELY,  # 'R'
        24: SequenceLikelihood.LIKELY,  # 'S'
        33: SequenceLikelihood.LIKELY,  # 'T'
        47: SequenceLikelihood.LIKELY,  # 'U'
        37: SequenceLikelihood.LIKELY,  # 'V'
        49: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        7: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        26: SequenceLikelihood.UNLIKELY,  # 'c'
        10: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        16: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.POSITIVE,  # 'h'
        5: SequenceLikelihood.POSITIVE,  # 'i'
        21: SequenceLikelihood.LIKELY,  # 'j'
        12: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        55: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.POSITIVE,  # 'r'
        6: SequenceLikelihood.UNLIKELY,  # 's'
        3: SequenceLikelihood.UNLIKELY,  # 't'
        17: SequenceLikelihood.LIKELY,  # 'u'
        14: SequenceLikelihood.LIKELY,  # 'v'
        46: SequenceLikelihood.LIKELY,  # 'w'
        48: SequenceLikelihood.UNLIKELY,  # 'x'
        23: SequenceLikelihood.LIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        51: SequenceLikelihood.UNLIKELY,  # 'Å'
        58: SequenceLikelihood.UNLIKELY,  # 'Æ'
        52: SequenceLikelihood.UNLIKELY,  # 'Ø'
        18: SequenceLikelihood.UNLIKELY,  # 'å'
        31: SequenceLikelihood.UNLIKELY,  # 'æ'
        22: SequenceLikelihood.LIKELY,  # 'ø'
    },
    47: {  # 'U'
        27: SequenceLikelihood.UNLIKELY,  # 'A'
        35: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        25: SequenceLikelihood.LIKELY,  # 'D'
        30: SequenceLikelihood.UNLIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        29: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        38: SequenceLikelihood.LIKELY,  # 'K'
        40: SequenceLikelihood.LIKELY,  # 'L'
        32: SequenceLikelihood.LIKELY,  # 'M'
        28: SequenceLikelihood.LIKELY,  # 'N'
        42: SequenceLikelihood.UNLIKELY,  # 'O'
        39: SequenceLikelihood.UNLIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.LIKELY,  # 'R'
        24: SequenceLikelihood.POSITIVE,  # 'S'
        33: SequenceLikelihood.LIKELY,  # 'T'
        47: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        49: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        7: SequenceLikelihood.LIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        26: SequenceLikelihood.UNLIKELY,  # 'c'
        10: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        16: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.LIKELY,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        12: SequenceLikelihood.LIKELY,  # 'k'
        8: SequenceLikelihood.LIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        9: SequenceLikelihood.UNLIKELY,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        55: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.LIKELY,  # 'r'
        6: SequenceLikelihood.LIKELY,  # 's'
        3: SequenceLikelihood.POSITIVE,  # 't'
        17: SequenceLikelihood.UNLIKELY,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'w'
        48: SequenceLikelihood.UNLIKELY,  # 'x'
        23: SequenceLikelihood.UNLIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        51: SequenceLikelihood.UNLIKELY,  # 'Å'
        58: SequenceLikelihood.NEGATIVE,  # 'Æ'
        52: SequenceLikelihood.UNLIKELY,  # 'Ø'
        18: SequenceLikelihood.UNLIKELY,  # 'å'
        31: SequenceLikelihood.UNLIKELY,  # 'æ'
        22: SequenceLikelihood.UNLIKELY,  # 'ø'
    },
    37: {  # 'V'
        27: SequenceLikelihood.LIKELY,  # 'A'
        35: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        25: SequenceLikelihood.UNLIKELY,  # 'D'
        30: SequenceLikelihood.LIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.LIKELY,  # 'G'
        29: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.LIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        38: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.LIKELY,  # 'M'
        28: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.UNLIKELY,  # 'O'
        39: SequenceLikelihood.UNLIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        24: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        47: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        49: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        7: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        26: SequenceLikelihood.UNLIKELY,  # 'c'
        10: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        16: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.POSITIVE,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        12: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        9: SequenceLikelihood.LIKELY,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        55: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.UNLIKELY,  # 'r'
        6: SequenceLikelihood.UNLIKELY,  # 's'
        3: SequenceLikelihood.UNLIKELY,  # 't'
        17: SequenceLikelihood.LIKELY,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'w'
        48: SequenceLikelihood.UNLIKELY,  # 'x'
        23: SequenceLikelihood.UNLIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        51: SequenceLikelihood.UNLIKELY,  # 'Å'
        58: SequenceLikelihood.UNLIKELY,  # 'Æ'
        52: SequenceLikelihood.UNLIKELY,  # 'Ø'
        18: SequenceLikelihood.LIKELY,  # 'å'
        31: SequenceLikelihood.LIKELY,  # 'æ'
        22: SequenceLikelihood.UNLIKELY,  # 'ø'
    },
    49: {  # 'W'
        27: SequenceLikelihood.UNLIKELY,  # 'A'
        35: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        25: SequenceLikelihood.UNLIKELY,  # 'D'
        30: SequenceLikelihood.UNLIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        29: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        38: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        28: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.UNLIKELY,  # 'O'
        39: SequenceLikelihood.UNLIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        24: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        47: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        49: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        7: SequenceLikelihood.LIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        26: SequenceLikelihood.UNLIKELY,  # 'c'
        10: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.LIKELY,  # 'e'
        16: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.LIKELY,  # 'h'
        5: SequenceLikelihood.POSITIVE,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        12: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        9: SequenceLikelihood.LIKELY,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        55: SequenceLikelihood.NEGATIVE,  # 'q'
        2: SequenceLikelihood.UNLIKELY,  # 'r'
        6: SequenceLikelihood.UNLIKELY,  # 's'
        3: SequenceLikelihood.UNLIKELY,  # 't'
        17: SequenceLikelihood.UNLIKELY,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'w'
        48: SequenceLikelihood.UNLIKELY,  # 'x'
        23: SequenceLikelihood.UNLIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        51: SequenceLikelihood.NEGATIVE,  # 'Å'
        58: SequenceLikelihood.UNLIKELY,  # 'Æ'
        52: SequenceLikelihood.NEGATIVE,  # 'Ø'
        18: SequenceLikelihood.UNLIKELY,  # 'å'
        31: SequenceLikelihood.UNLIKELY,  # 'æ'
        22: SequenceLikelihood.UNLIKELY,  # 'ø'
    },
    54: {  # 'X'
        27: SequenceLikelihood.UNLIKELY,  # 'A'
        35: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        25: SequenceLikelihood.UNLIKELY,  # 'D'
        30: SequenceLikelihood.UNLIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        29: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        38: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        28: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.UNLIKELY,  # 'O'
        39: SequenceLikelihood.UNLIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        24: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        47: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        49: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        7: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        26: SequenceLikelihood.UNLIKELY,  # 'c'
        10: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        16: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.UNLIKELY,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        12: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        9: SequenceLikelihood.UNLIKELY,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        55: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.UNLIKELY,  # 'r'
        6: SequenceLikelihood.UNLIKELY,  # 's'
        3: SequenceLikelihood.UNLIKELY,  # 't'
        17: SequenceLikelihood.UNLIKELY,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'w'
        48: SequenceLikelihood.UNLIKELY,  # 'x'
        23: SequenceLikelihood.UNLIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        51: SequenceLikelihood.UNLIKELY,  # 'Å'
        58: SequenceLikelihood.NEGATIVE,  # 'Æ'
        52: SequenceLikelihood.UNLIKELY,  # 'Ø'
        18: SequenceLikelihood.UNLIKELY,  # 'å'
        31: SequenceLikelihood.NEGATIVE,  # 'æ'
        22: SequenceLikelihood.NEGATIVE,  # 'ø'
    },
    53: {  # 'Y'
        27: SequenceLikelihood.UNLIKELY,  # 'A'
        35: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        25: SequenceLikelihood.UNLIKELY,  # 'D'
        30: SequenceLikelihood.UNLIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        29: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        38: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        28: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.UNLIKELY,  # 'O'
        39: SequenceLikelihood.UNLIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        24: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        47: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        49: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        7: SequenceLikelihood.LIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        26: SequenceLikelihood.UNLIKELY,  # 'c'
        10: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        16: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.UNLIKELY,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        12: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        9: SequenceLikelihood.LIKELY,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        55: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.UNLIKELY,  # 'r'
        6: SequenceLikelihood.UNLIKELY,  # 's'
        3: SequenceLikelihood.UNLIKELY,  # 't'
        17: SequenceLikelihood.UNLIKELY,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'w'
        48: SequenceLikelihood.UNLIKELY,  # 'x'
        23: SequenceLikelihood.UNLIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        51: SequenceLikelihood.UNLIKELY,  # 'Å'
        58: SequenceLikelihood.NEGATIVE,  # 'Æ'
        52: SequenceLikelihood.UNLIKELY,  # 'Ø'
        18: SequenceLikelihood.NEGATIVE,  # 'å'
        31: SequenceLikelihood.NEGATIVE,  # 'æ'
        22: SequenceLikelihood.NEGATIVE,  # 'ø'
    },
    56: {  # 'Z'
        27: SequenceLikelihood.UNLIKELY,  # 'A'
        35: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        25: SequenceLikelihood.UNLIKELY,  # 'D'
        30: SequenceLikelihood.UNLIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        29: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        38: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        28: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.UNLIKELY,  # 'O'
        39: SequenceLikelihood.UNLIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        24: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        47: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        49: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        7: SequenceLikelihood.LIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        26: SequenceLikelihood.UNLIKELY,  # 'c'
        10: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.LIKELY,  # 'e'
        16: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.UNLIKELY,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        12: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        9: SequenceLikelihood.UNLIKELY,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        55: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.UNLIKELY,  # 'r'
        6: SequenceLikelihood.UNLIKELY,  # 's'
        3: SequenceLikelihood.UNLIKELY,  # 't'
        17: SequenceLikelihood.UNLIKELY,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'w'
        48: SequenceLikelihood.UNLIKELY,  # 'x'
        23: SequenceLikelihood.UNLIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        51: SequenceLikelihood.NEGATIVE,  # 'Å'
        58: SequenceLikelihood.UNLIKELY,  # 'Æ'
        52: SequenceLikelihood.UNLIKELY,  # 'Ø'
        18: SequenceLikelihood.NEGATIVE,  # 'å'
        31: SequenceLikelihood.NEGATIVE,  # 'æ'
        22: SequenceLikelihood.NEGATIVE,  # 'ø'
    },
    7: {  # 'a'
        27: SequenceLikelihood.UNLIKELY,  # 'A'
        35: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        25: SequenceLikelihood.UNLIKELY,  # 'D'
        30: SequenceLikelihood.UNLIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        29: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        38: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        28: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.UNLIKELY,  # 'O'
        39: SequenceLikelihood.UNLIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        24: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        47: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        49: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        7: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.POSITIVE,  # 'b'
        26: SequenceLikelihood.POSITIVE,  # 'c'
        10: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        16: SequenceLikelihood.POSITIVE,  # 'f'
        11: SequenceLikelihood.POSITIVE,  # 'g'
        20: SequenceLikelihood.POSITIVE,  # 'h'
        5: SequenceLikelihood.POSITIVE,  # 'i'
        21: SequenceLikelihood.LIKELY,  # 'j'
        12: SequenceLikelihood.POSITIVE,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        9: SequenceLikelihood.LIKELY,  # 'o'
        15: SequenceLikelihood.POSITIVE,  # 'p'
        55: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.POSITIVE,  # 'r'
        6: SequenceLikelihood.POSITIVE,  # 's'
        3: SequenceLikelihood.POSITIVE,  # 't'
        17: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.POSITIVE,  # 'v'
        46: SequenceLikelihood.LIKELY,  # 'w'
        48: SequenceLikelihood.LIKELY,  # 'x'
        23: SequenceLikelihood.POSITIVE,  # 'y'
        50: SequenceLikelihood.LIKELY,  # 'z'
        51: SequenceLikelihood.UNLIKELY,  # 'Å'
        58: SequenceLikelihood.NEGATIVE,  # 'Æ'
        52: SequenceLikelihood.UNLIKELY,  # 'Ø'
        18: SequenceLikelihood.UNLIKELY,  # 'å'
        31: SequenceLikelihood.UNLIKELY,  # 'æ'
        22: SequenceLikelihood.UNLIKELY,  # 'ø'
    },
    19: {  # 'b'
        27: SequenceLikelihood.UNLIKELY,  # 'A'
        35: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        25: SequenceLikelihood.UNLIKELY,  # 'D'
        30: SequenceLikelihood.UNLIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        29: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        38: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        28: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.UNLIKELY,  # 'O'
        39: SequenceLikelihood.UNLIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        24: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        47: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        49: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        7: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.POSITIVE,  # 'b'
        26: SequenceLikelihood.UNLIKELY,  # 'c'
        10: SequenceLikelihood.LIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        16: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.POSITIVE,  # 'i'
        21: SequenceLikelihood.LIKELY,  # 'j'
        12: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.LIKELY,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        55: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.POSITIVE,  # 'r'
        6: SequenceLikelihood.POSITIVE,  # 's'
        3: SequenceLikelihood.UNLIKELY,  # 't'
        17: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'w'
        48: SequenceLikelihood.UNLIKELY,  # 'x'
        23: SequenceLikelihood.POSITIVE,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        51: SequenceLikelihood.UNLIKELY,  # 'Å'
        58: SequenceLikelihood.NEGATIVE,  # 'Æ'
        52: SequenceLikelihood.UNLIKELY,  # 'Ø'
        18: SequenceLikelihood.POSITIVE,  # 'å'
        31: SequenceLikelihood.POSITIVE,  # 'æ'
        22: SequenceLikelihood.POSITIVE,  # 'ø'
    },
    26: {  # 'c'
        27: SequenceLikelihood.UNLIKELY,  # 'A'
        35: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        25: SequenceLikelihood.UNLIKELY,  # 'D'
        30: SequenceLikelihood.UNLIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        29: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        38: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        28: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.UNLIKELY,  # 'O'
        39: SequenceLikelihood.UNLIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        24: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        47: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        49: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        7: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        26: SequenceLikelihood.LIKELY,  # 'c'
        10: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        16: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.POSITIVE,  # 'h'
        5: SequenceLikelihood.POSITIVE,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        12: SequenceLikelihood.POSITIVE,  # 'k'
        8: SequenceLikelihood.LIKELY,  # 'l'
        13: SequenceLikelihood.LIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        55: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.POSITIVE,  # 'r'
        6: SequenceLikelihood.LIKELY,  # 's'
        3: SequenceLikelihood.POSITIVE,  # 't'
        17: SequenceLikelihood.LIKELY,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'w'
        48: SequenceLikelihood.UNLIKELY,  # 'x'
        23: SequenceLikelihood.LIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        51: SequenceLikelihood.UNLIKELY,  # 'Å'
        58: SequenceLikelihood.NEGATIVE,  # 'Æ'
        52: SequenceLikelihood.NEGATIVE,  # 'Ø'
        18: SequenceLikelihood.UNLIKELY,  # 'å'
        31: SequenceLikelihood.UNLIKELY,  # 'æ'
        22: SequenceLikelihood.UNLIKELY,  # 'ø'
    },
    10: {  # 'd'
        27: SequenceLikelihood.UNLIKELY,  # 'A'
        35: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        25: SequenceLikelihood.UNLIKELY,  # 'D'
        30: SequenceLikelihood.UNLIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        29: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        38: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        28: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.UNLIKELY,  # 'O'
        39: SequenceLikelihood.UNLIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        24: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        47: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        49: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        7: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.POSITIVE,  # 'b'
        26: SequenceLikelihood.LIKELY,  # 'c'
        10: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        16: SequenceLikelihood.POSITIVE,  # 'f'
        11: SequenceLikelihood.POSITIVE,  # 'g'
        20: SequenceLikelihood.LIKELY,  # 'h'
        5: SequenceLikelihood.POSITIVE,  # 'i'
        21: SequenceLikelihood.LIKELY,  # 'j'
        12: SequenceLikelihood.POSITIVE,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.LIKELY,  # 'p'
        55: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.POSITIVE,  # 'r'
        6: SequenceLikelihood.POSITIVE,  # 's'
        3: SequenceLikelihood.POSITIVE,  # 't'
        17: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.POSITIVE,  # 'v'
        46: SequenceLikelihood.LIKELY,  # 'w'
        48: SequenceLikelihood.UNLIKELY,  # 'x'
        23: SequenceLikelihood.POSITIVE,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        51: SequenceLikelihood.UNLIKELY,  # 'Å'
        58: SequenceLikelihood.NEGATIVE,  # 'Æ'
        52: SequenceLikelihood.UNLIKELY,  # 'Ø'
        18: SequenceLikelihood.LIKELY,  # 'å'
        31: SequenceLikelihood.UNLIKELY,  # 'æ'
        22: SequenceLikelihood.POSITIVE,  # 'ø'
    },
    1: {  # 'e'
        27: SequenceLikelihood.UNLIKELY,  # 'A'
        35: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        25: SequenceLikelihood.UNLIKELY,  # 'D'
        30: SequenceLikelihood.UNLIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        29: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        38: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        28: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.UNLIKELY,  # 'O'
        39: SequenceLikelihood.UNLIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        24: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        47: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        49: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        7: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.POSITIVE,  # 'b'
        26: SequenceLikelihood.POSITIVE,  # 'c'
        10: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        16: SequenceLikelihood.POSITIVE,  # 'f'
        11: SequenceLikelihood.POSITIVE,  # 'g'
        20: SequenceLikelihood.POSITIVE,  # 'h'
        5: SequenceLikelihood.POSITIVE,  # 'i'
        21: SequenceLikelihood.LIKELY,  # 'j'
        12: SequenceLikelihood.POSITIVE,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.POSITIVE,  # 'p'
        55: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.POSITIVE,  # 'r'
        6: SequenceLikelihood.POSITIVE,  # 's'
        3: SequenceLikelihood.POSITIVE,  # 't'
        17: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.POSITIVE,  # 'v'
        46: SequenceLikelihood.POSITIVE,  # 'w'
        48: SequenceLikelihood.POSITIVE,  # 'x'
        23: SequenceLikelihood.POSITIVE,  # 'y'
        50: SequenceLikelihood.LIKELY,  # 'z'
        51: SequenceLikelihood.UNLIKELY,  # 'Å'
        58: SequenceLikelihood.NEGATIVE,  # 'Æ'
        52: SequenceLikelihood.UNLIKELY,  # 'Ø'
        18: SequenceLikelihood.LIKELY,  # 'å'
        31: SequenceLikelihood.UNLIKELY,  # 'æ'
        22: SequenceLikelihood.UNLIKELY,  # 'ø'
    },
    16: {  # 'f'
        27: SequenceLikelihood.UNLIKELY,  # 'A'
        35: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        25: SequenceLikelihood.UNLIKELY,  # 'D'
        30: SequenceLikelihood.UNLIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        29: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        38: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        28: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.UNLIKELY,  # 'O'
        39: SequenceLikelihood.UNLIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        24: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        47: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        49: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        7: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        26: SequenceLikelihood.UNLIKELY,  # 'c'
        10: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        16: SequenceLikelihood.POSITIVE,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.POSITIVE,  # 'i'
        21: SequenceLikelihood.POSITIVE,  # 'j'
        12: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        55: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.POSITIVE,  # 'r'
        6: SequenceLikelihood.LIKELY,  # 's'
        3: SequenceLikelihood.POSITIVE,  # 't'
        17: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'w'
        48: SequenceLikelihood.UNLIKELY,  # 'x'
        23: SequenceLikelihood.POSITIVE,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        51: SequenceLikelihood.UNLIKELY,  # 'Å'
        58: SequenceLikelihood.NEGATIVE,  # 'Æ'
        52: SequenceLikelihood.UNLIKELY,  # 'Ø'
        18: SequenceLikelihood.POSITIVE,  # 'å'
        31: SequenceLikelihood.LIKELY,  # 'æ'
        22: SequenceLikelihood.POSITIVE,  # 'ø'
    },
    11: {  # 'g'
        27: SequenceLikelihood.UNLIKELY,  # 'A'
        35: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        25: SequenceLikelihood.UNLIKELY,  # 'D'
        30: SequenceLikelihood.UNLIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        29: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        38: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        28: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.UNLIKELY,  # 'O'
        39: SequenceLikelihood.UNLIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        24: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        47: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        49: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        7: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.LIKELY,  # 'b'
        26: SequenceLikelihood.UNLIKELY,  # 'c'
        10: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        16: SequenceLikelihood.LIKELY,  # 'f'
        11: SequenceLikelihood.POSITIVE,  # 'g'
        20: SequenceLikelihood.POSITIVE,  # 'h'
        5: SequenceLikelihood.POSITIVE,  # 'i'
        21: SequenceLikelihood.POSITIVE,  # 'j'
        12: SequenceLikelihood.LIKELY,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.LIKELY,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.LIKELY,  # 'p'
        55: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.POSITIVE,  # 'r'
        6: SequenceLikelihood.POSITIVE,  # 's'
        3: SequenceLikelihood.POSITIVE,  # 't'
        17: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.POSITIVE,  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'w'
        48: SequenceLikelihood.UNLIKELY,  # 'x'
        23: SequenceLikelihood.POSITIVE,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        51: SequenceLikelihood.UNLIKELY,  # 'Å'
        58: SequenceLikelihood.UNLIKELY,  # 'Æ'
        52: SequenceLikelihood.UNLIKELY,  # 'Ø'
        18: SequenceLikelihood.POSITIVE,  # 'å'
        31: SequenceLikelihood.UNLIKELY,  # 'æ'
        22: SequenceLikelihood.LIKELY,  # 'ø'
    },
    20: {  # 'h'
        27: SequenceLikelihood.UNLIKELY,  # 'A'
        35: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        25: SequenceLikelihood.UNLIKELY,  # 'D'
        30: SequenceLikelihood.UNLIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        29: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        38: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        28: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.UNLIKELY,  # 'O'
        39: SequenceLikelihood.UNLIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        24: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        47: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        49: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        7: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        26: SequenceLikelihood.UNLIKELY,  # 'c'
        10: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        16: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.POSITIVE,  # 'i'
        21: SequenceLikelihood.POSITIVE,  # 'j'
        12: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.LIKELY,  # 'l'
        13: SequenceLikelihood.LIKELY,  # 'm'
        4: SequenceLikelihood.LIKELY,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        55: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.POSITIVE,  # 'r'
        6: SequenceLikelihood.LIKELY,  # 's'
        3: SequenceLikelihood.POSITIVE,  # 't'
        17: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.POSITIVE,  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'w'
        48: SequenceLikelihood.UNLIKELY,  # 'x'
        23: SequenceLikelihood.POSITIVE,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        51: SequenceLikelihood.NEGATIVE,  # 'Å'
        58: SequenceLikelihood.NEGATIVE,  # 'Æ'
        52: SequenceLikelihood.UNLIKELY,  # 'Ø'
        18: SequenceLikelihood.POSITIVE,  # 'å'
        31: SequenceLikelihood.LIKELY,  # 'æ'
        22: SequenceLikelihood.POSITIVE,  # 'ø'
    },
    5: {  # 'i'
        27: SequenceLikelihood.UNLIKELY,  # 'A'
        35: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        25: SequenceLikelihood.UNLIKELY,  # 'D'
        30: SequenceLikelihood.UNLIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        29: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        38: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        28: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.LIKELY,  # 'O'
        39: SequenceLikelihood.LIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        24: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        47: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        49: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        7: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.POSITIVE,  # 'b'
        26: SequenceLikelihood.POSITIVE,  # 'c'
        10: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        16: SequenceLikelihood.POSITIVE,  # 'f'
        11: SequenceLikelihood.POSITIVE,  # 'g'
        20: SequenceLikelihood.LIKELY,  # 'h'
        5: SequenceLikelihood.LIKELY,  # 'i'
        21: SequenceLikelihood.LIKELY,  # 'j'
        12: SequenceLikelihood.POSITIVE,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.POSITIVE,  # 'p'
        55: SequenceLikelihood.LIKELY,  # 'q'
        2: SequenceLikelihood.POSITIVE,  # 'r'
        6: SequenceLikelihood.POSITIVE,  # 's'
        3: SequenceLikelihood.POSITIVE,  # 't'
        17: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.POSITIVE,  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'w'
        48: SequenceLikelihood.LIKELY,  # 'x'
        23: SequenceLikelihood.UNLIKELY,  # 'y'
        50: SequenceLikelihood.LIKELY,  # 'z'
        51: SequenceLikelihood.UNLIKELY,  # 'Å'
        58: SequenceLikelihood.NEGATIVE,  # 'Æ'
        52: SequenceLikelihood.UNLIKELY,  # 'Ø'
        18: SequenceLikelihood.LIKELY,  # 'å'
        31: SequenceLikelihood.UNLIKELY,  # 'æ'
        22: SequenceLikelihood.LIKELY,  # 'ø'
    },
    21: {  # 'j'
        27: SequenceLikelihood.UNLIKELY,  # 'A'
        35: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        25: SequenceLikelihood.UNLIKELY,  # 'D'
        30: SequenceLikelihood.UNLIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        29: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        38: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        28: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.UNLIKELY,  # 'O'
        39: SequenceLikelihood.UNLIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        24: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        47: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        49: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        7: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        26: SequenceLikelihood.UNLIKELY,  # 'c'
        10: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        16: SequenceLikelihood.LIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.LIKELY,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        12: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        55: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.UNLIKELY,  # 'r'
        6: SequenceLikelihood.UNLIKELY,  # 's'
        3: SequenceLikelihood.UNLIKELY,  # 't'
        17: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'w'
        48: SequenceLikelihood.UNLIKELY,  # 'x'
        23: SequenceLikelihood.UNLIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        51: SequenceLikelihood.NEGATIVE,  # 'Å'
        58: SequenceLikelihood.UNLIKELY,  # 'Æ'
        52: SequenceLikelihood.UNLIKELY,  # 'Ø'
        18: SequenceLikelihood.LIKELY,  # 'å'
        31: SequenceLikelihood.POSITIVE,  # 'æ'
        22: SequenceLikelihood.POSITIVE,  # 'ø'
    },
    12: {  # 'k'
        27: SequenceLikelihood.UNLIKELY,  # 'A'
        35: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        25: SequenceLikelihood.UNLIKELY,  # 'D'
        30: SequenceLikelihood.UNLIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        29: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        38: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        28: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.UNLIKELY,  # 'O'
        39: SequenceLikelihood.UNLIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        24: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        47: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        49: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        7: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.LIKELY,  # 'b'
        26: SequenceLikelihood.UNLIKELY,  # 'c'
        10: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        16: SequenceLikelihood.LIKELY,  # 'f'
        11: SequenceLikelihood.LIKELY,  # 'g'
        20: SequenceLikelihood.LIKELY,  # 'h'
        5: SequenceLikelihood.POSITIVE,  # 'i'
        21: SequenceLikelihood.POSITIVE,  # 'j'
        12: SequenceLikelihood.POSITIVE,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.LIKELY,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.LIKELY,  # 'p'
        55: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.POSITIVE,  # 'r'
        6: SequenceLikelihood.POSITIVE,  # 's'
        3: SequenceLikelihood.POSITIVE,  # 't'
        17: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.POSITIVE,  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'w'
        48: SequenceLikelihood.UNLIKELY,  # 'x'
        23: SequenceLikelihood.POSITIVE,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        51: SequenceLikelihood.UNLIKELY,  # 'Å'
        58: SequenceLikelihood.NEGATIVE,  # 'Æ'
        52: SequenceLikelihood.UNLIKELY,  # 'Ø'
        18: SequenceLikelihood.LIKELY,  # 'å'
        31: SequenceLikelihood.UNLIKELY,  # 'æ'
        22: SequenceLikelihood.LIKELY,  # 'ø'
    },
    8: {  # 'l'
        27: SequenceLikelihood.UNLIKELY,  # 'A'
        35: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        25: SequenceLikelihood.UNLIKELY,  # 'D'
        30: SequenceLikelihood.UNLIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        29: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        38: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        28: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.UNLIKELY,  # 'O'
        39: SequenceLikelihood.UNLIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        24: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        47: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        49: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        7: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.POSITIVE,  # 'b'
        26: SequenceLikelihood.LIKELY,  # 'c'
        10: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        16: SequenceLikelihood.POSITIVE,  # 'f'
        11: SequenceLikelihood.POSITIVE,  # 'g'
        20: SequenceLikelihood.POSITIVE,  # 'h'
        5: SequenceLikelihood.POSITIVE,  # 'i'
        21: SequenceLikelihood.POSITIVE,  # 'j'
        12: SequenceLikelihood.POSITIVE,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.LIKELY,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.POSITIVE,  # 'p'
        55: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.LIKELY,  # 'r'
        6: SequenceLikelihood.POSITIVE,  # 's'
        3: SequenceLikelihood.POSITIVE,  # 't'
        17: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.POSITIVE,  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'w'
        48: SequenceLikelihood.UNLIKELY,  # 'x'
        23: SequenceLikelihood.POSITIVE,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        51: SequenceLikelihood.UNLIKELY,  # 'Å'
        58: SequenceLikelihood.UNLIKELY,  # 'Æ'
        52: SequenceLikelihood.UNLIKELY,  # 'Ø'
        18: SequenceLikelihood.POSITIVE,  # 'å'
        31: SequenceLikelihood.POSITIVE,  # 'æ'
        22: SequenceLikelihood.POSITIVE,  # 'ø'
    },
    13: {  # 'm'
        27: SequenceLikelihood.UNLIKELY,  # 'A'
        35: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        25: SequenceLikelihood.UNLIKELY,  # 'D'
        30: SequenceLikelihood.UNLIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        29: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        38: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        28: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.UNLIKELY,  # 'O'
        39: SequenceLikelihood.UNLIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        24: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        47: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        49: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        7: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.POSITIVE,  # 'b'
        26: SequenceLikelihood.UNLIKELY,  # 'c'
        10: SequenceLikelihood.LIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        16: SequenceLikelihood.POSITIVE,  # 'f'
        11: SequenceLikelihood.POSITIVE,  # 'g'
        20: SequenceLikelihood.POSITIVE,  # 'h'
        5: SequenceLikelihood.POSITIVE,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        12: SequenceLikelihood.LIKELY,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.POSITIVE,  # 'p'
        55: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.POSITIVE,  # 'r'
        6: SequenceLikelihood.POSITIVE,  # 's'
        3: SequenceLikelihood.POSITIVE,  # 't'
        17: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.LIKELY,  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'w'
        48: SequenceLikelihood.UNLIKELY,  # 'x'
        23: SequenceLikelihood.POSITIVE,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        51: SequenceLikelihood.UNLIKELY,  # 'Å'
        58: SequenceLikelihood.NEGATIVE,  # 'Æ'
        52: SequenceLikelihood.UNLIKELY,  # 'Ø'
        18: SequenceLikelihood.POSITIVE,  # 'å'
        31: SequenceLikelihood.LIKELY,  # 'æ'
        22: SequenceLikelihood.POSITIVE,  # 'ø'
    },
    4: {  # 'n'
        27: SequenceLikelihood.UNLIKELY,  # 'A'
        35: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        25: SequenceLikelihood.UNLIKELY,  # 'D'
        30: SequenceLikelihood.UNLIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        29: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        38: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        28: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.UNLIKELY,  # 'O'
        39: SequenceLikelihood.UNLIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        24: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        47: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        49: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        7: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.POSITIVE,  # 'b'
        26: SequenceLikelihood.POSITIVE,  # 'c'
        10: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        16: SequenceLikelihood.POSITIVE,  # 'f'
        11: SequenceLikelihood.POSITIVE,  # 'g'
        20: SequenceLikelihood.POSITIVE,  # 'h'
        5: SequenceLikelihood.POSITIVE,  # 'i'
        21: SequenceLikelihood.POSITIVE,  # 'j'
        12: SequenceLikelihood.POSITIVE,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.LIKELY,  # 'p'
        55: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.POSITIVE,  # 'r'
        6: SequenceLikelihood.POSITIVE,  # 's'
        3: SequenceLikelihood.POSITIVE,  # 't'
        17: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.POSITIVE,  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'w'
        48: SequenceLikelihood.UNLIKELY,  # 'x'
        23: SequenceLikelihood.POSITIVE,  # 'y'
        50: SequenceLikelihood.LIKELY,  # 'z'
        51: SequenceLikelihood.UNLIKELY,  # 'Å'
        58: SequenceLikelihood.UNLIKELY,  # 'Æ'
        52: SequenceLikelihood.UNLIKELY,  # 'Ø'
        18: SequenceLikelihood.POSITIVE,  # 'å'
        31: SequenceLikelihood.POSITIVE,  # 'æ'
        22: SequenceLikelihood.POSITIVE,  # 'ø'
    },
    9: {  # 'o'
        27: SequenceLikelihood.UNLIKELY,  # 'A'
        35: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        25: SequenceLikelihood.UNLIKELY,  # 'D'
        30: SequenceLikelihood.UNLIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        29: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        38: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        28: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.UNLIKELY,  # 'O'
        39: SequenceLikelihood.UNLIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        24: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        47: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        49: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        7: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.POSITIVE,  # 'b'
        26: SequenceLikelihood.POSITIVE,  # 'c'
        10: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        16: SequenceLikelihood.POSITIVE,  # 'f'
        11: SequenceLikelihood.POSITIVE,  # 'g'
        20: SequenceLikelihood.POSITIVE,  # 'h'
        5: SequenceLikelihood.POSITIVE,  # 'i'
        21: SequenceLikelihood.LIKELY,  # 'j'
        12: SequenceLikelihood.POSITIVE,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.POSITIVE,  # 'p'
        55: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.POSITIVE,  # 'r'
        6: SequenceLikelihood.POSITIVE,  # 's'
        3: SequenceLikelihood.POSITIVE,  # 't'
        17: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.POSITIVE,  # 'v'
        46: SequenceLikelihood.POSITIVE,  # 'w'
        48: SequenceLikelihood.LIKELY,  # 'x'
        23: SequenceLikelihood.LIKELY,  # 'y'
        50: SequenceLikelihood.LIKELY,  # 'z'
        51: SequenceLikelihood.UNLIKELY,  # 'Å'
        58: SequenceLikelihood.NEGATIVE,  # 'Æ'
        52: SequenceLikelihood.UNLIKELY,  # 'Ø'
        18: SequenceLikelihood.UNLIKELY,  # 'å'
        31: SequenceLikelihood.UNLIKELY,  # 'æ'
        22: SequenceLikelihood.UNLIKELY,  # 'ø'
    },
    15: {  # 'p'
        27: SequenceLikelihood.UNLIKELY,  # 'A'
        35: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        25: SequenceLikelihood.UNLIKELY,  # 'D'
        30: SequenceLikelihood.UNLIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        29: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        38: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        28: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.UNLIKELY,  # 'O'
        39: SequenceLikelihood.UNLIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        24: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        47: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        49: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        7: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.LIKELY,  # 'b'
        26: SequenceLikelihood.LIKELY,  # 'c'
        10: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        16: SequenceLikelihood.POSITIVE,  # 'f'
        11: SequenceLikelihood.POSITIVE,  # 'g'
        20: SequenceLikelihood.POSITIVE,  # 'h'
        5: SequenceLikelihood.POSITIVE,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        12: SequenceLikelihood.LIKELY,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.LIKELY,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.POSITIVE,  # 'p'
        55: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.POSITIVE,  # 'r'
        6: SequenceLikelihood.POSITIVE,  # 's'
        3: SequenceLikelihood.POSITIVE,  # 't'
        17: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.LIKELY,  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'w'
        48: SequenceLikelihood.UNLIKELY,  # 'x'
        23: SequenceLikelihood.LIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        51: SequenceLikelihood.UNLIKELY,  # 'Å'
        58: SequenceLikelihood.UNLIKELY,  # 'Æ'
        52: SequenceLikelihood.UNLIKELY,  # 'Ø'
        18: SequenceLikelihood.POSITIVE,  # 'å'
        31: SequenceLikelihood.UNLIKELY,  # 'æ'
        22: SequenceLikelihood.POSITIVE,  # 'ø'
    },
    55: {  # 'q'
        27: SequenceLikelihood.UNLIKELY,  # 'A'
        35: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        25: SequenceLikelihood.UNLIKELY,  # 'D'
        30: SequenceLikelihood.UNLIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        29: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        38: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        28: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.UNLIKELY,  # 'O'
        39: SequenceLikelihood.UNLIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        24: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        47: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        49: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        7: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        26: SequenceLikelihood.UNLIKELY,  # 'c'
        10: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        16: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.UNLIKELY,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        12: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        9: SequenceLikelihood.UNLIKELY,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        55: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.UNLIKELY,  # 'r'
        6: SequenceLikelihood.UNLIKELY,  # 's'
        3: SequenceLikelihood.UNLIKELY,  # 't'
        17: SequenceLikelihood.LIKELY,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'w'
        48: SequenceLikelihood.UNLIKELY,  # 'x'
        23: SequenceLikelihood.UNLIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        51: SequenceLikelihood.NEGATIVE,  # 'Å'
        58: SequenceLikelihood.NEGATIVE,  # 'Æ'
        52: SequenceLikelihood.NEGATIVE,  # 'Ø'
        18: SequenceLikelihood.NEGATIVE,  # 'å'
        31: SequenceLikelihood.NEGATIVE,  # 'æ'
        22: SequenceLikelihood.NEGATIVE,  # 'ø'
    },
    2: {  # 'r'
        27: SequenceLikelihood.UNLIKELY,  # 'A'
        35: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        25: SequenceLikelihood.UNLIKELY,  # 'D'
        30: SequenceLikelihood.UNLIKELY,  # 'E'
        34: SequenceLikelihood.LIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        29: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        38: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        28: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.UNLIKELY,  # 'O'
        39: SequenceLikelihood.UNLIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        24: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        47: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        49: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        7: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.POSITIVE,  # 'b'
        26: SequenceLikelihood.POSITIVE,  # 'c'
        10: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        16: SequenceLikelihood.POSITIVE,  # 'f'
        11: SequenceLikelihood.POSITIVE,  # 'g'
        20: SequenceLikelihood.POSITIVE,  # 'h'
        5: SequenceLikelihood.POSITIVE,  # 'i'
        21: SequenceLikelihood.LIKELY,  # 'j'
        12: SequenceLikelihood.POSITIVE,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.POSITIVE,  # 'p'
        55: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.POSITIVE,  # 'r'
        6: SequenceLikelihood.POSITIVE,  # 's'
        3: SequenceLikelihood.POSITIVE,  # 't'
        17: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.POSITIVE,  # 'v'
        46: SequenceLikelihood.LIKELY,  # 'w'
        48: SequenceLikelihood.UNLIKELY,  # 'x'
        23: SequenceLikelihood.POSITIVE,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        51: SequenceLikelihood.UNLIKELY,  # 'Å'
        58: SequenceLikelihood.UNLIKELY,  # 'Æ'
        52: SequenceLikelihood.UNLIKELY,  # 'Ø'
        18: SequenceLikelihood.POSITIVE,  # 'å'
        31: SequenceLikelihood.LIKELY,  # 'æ'
        22: SequenceLikelihood.POSITIVE,  # 'ø'
    },
    6: {  # 's'
        27: SequenceLikelihood.UNLIKELY,  # 'A'
        35: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        25: SequenceLikelihood.UNLIKELY,  # 'D'
        30: SequenceLikelihood.UNLIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        29: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        38: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        28: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.UNLIKELY,  # 'O'
        39: SequenceLikelihood.UNLIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        24: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        47: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        49: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        7: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.POSITIVE,  # 'b'
        26: SequenceLikelihood.POSITIVE,  # 'c'
        10: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        16: SequenceLikelihood.POSITIVE,  # 'f'
        11: SequenceLikelihood.POSITIVE,  # 'g'
        20: SequenceLikelihood.POSITIVE,  # 'h'
        5: SequenceLikelihood.POSITIVE,  # 'i'
        21: SequenceLikelihood.POSITIVE,  # 'j'
        12: SequenceLikelihood.POSITIVE,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.POSITIVE,  # 'p'
        55: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.POSITIVE,  # 'r'
        6: SequenceLikelihood.POSITIVE,  # 's'
        3: SequenceLikelihood.POSITIVE,  # 't'
        17: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.POSITIVE,  # 'v'
        46: SequenceLikelihood.LIKELY,  # 'w'
        48: SequenceLikelihood.UNLIKELY,  # 'x'
        23: SequenceLikelihood.POSITIVE,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        51: SequenceLikelihood.UNLIKELY,  # 'Å'
        58: SequenceLikelihood.UNLIKELY,  # 'Æ'
        52: SequenceLikelihood.UNLIKELY,  # 'Ø'
        18: SequenceLikelihood.POSITIVE,  # 'å'
        31: SequenceLikelihood.LIKELY,  # 'æ'
        22: SequenceLikelihood.POSITIVE,  # 'ø'
    },
    3: {  # 't'
        27: SequenceLikelihood.UNLIKELY,  # 'A'
        35: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        25: SequenceLikelihood.UNLIKELY,  # 'D'
        30: SequenceLikelihood.UNLIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        29: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        38: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        28: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.UNLIKELY,  # 'O'
        39: SequenceLikelihood.UNLIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        24: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        47: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        49: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        7: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.POSITIVE,  # 'b'
        26: SequenceLikelihood.POSITIVE,  # 'c'
        10: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        16: SequenceLikelihood.POSITIVE,  # 'f'
        11: SequenceLikelihood.POSITIVE,  # 'g'
        20: SequenceLikelihood.POSITIVE,  # 'h'
        5: SequenceLikelihood.POSITIVE,  # 'i'
        21: SequenceLikelihood.POSITIVE,  # 'j'
        12: SequenceLikelihood.POSITIVE,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.POSITIVE,  # 'p'
        55: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.POSITIVE,  # 'r'
        6: SequenceLikelihood.POSITIVE,  # 's'
        3: SequenceLikelihood.POSITIVE,  # 't'
        17: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.POSITIVE,  # 'v'
        46: SequenceLikelihood.LIKELY,  # 'w'
        48: SequenceLikelihood.UNLIKELY,  # 'x'
        23: SequenceLikelihood.POSITIVE,  # 'y'
        50: SequenceLikelihood.LIKELY,  # 'z'
        51: SequenceLikelihood.UNLIKELY,  # 'Å'
        58: SequenceLikelihood.UNLIKELY,  # 'Æ'
        52: SequenceLikelihood.UNLIKELY,  # 'Ø'
        18: SequenceLikelihood.POSITIVE,  # 'å'
        31: SequenceLikelihood.LIKELY,  # 'æ'
        22: SequenceLikelihood.POSITIVE,  # 'ø'
    },
    17: {  # 'u'
        27: SequenceLikelihood.UNLIKELY,  # 'A'
        35: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        25: SequenceLikelihood.UNLIKELY,  # 'D'
        30: SequenceLikelihood.UNLIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        29: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        38: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        28: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.UNLIKELY,  # 'O'
        39: SequenceLikelihood.UNLIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        24: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        47: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        49: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        7: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.POSITIVE,  # 'b'
        26: SequenceLikelihood.LIKELY,  # 'c'
        10: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        16: SequenceLikelihood.POSITIVE,  # 'f'
        11: SequenceLikelihood.POSITIVE,  # 'g'
        20: SequenceLikelihood.LIKELY,  # 'h'
        5: SequenceLikelihood.POSITIVE,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        12: SequenceLikelihood.POSITIVE,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        9: SequenceLikelihood.LIKELY,  # 'o'
        15: SequenceLikelihood.POSITIVE,  # 'p'
        55: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.POSITIVE,  # 'r'
        6: SequenceLikelihood.POSITIVE,  # 's'
        3: SequenceLikelihood.POSITIVE,  # 't'
        17: SequenceLikelihood.LIKELY,  # 'u'
        14: SequenceLikelihood.LIKELY,  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'w'
        48: SequenceLikelihood.LIKELY,  # 'x'
        23: SequenceLikelihood.LIKELY,  # 'y'
        50: SequenceLikelihood.LIKELY,  # 'z'
        51: SequenceLikelihood.NEGATIVE,  # 'Å'
        58: SequenceLikelihood.NEGATIVE,  # 'Æ'
        52: SequenceLikelihood.UNLIKELY,  # 'Ø'
        18: SequenceLikelihood.UNLIKELY,  # 'å'
        31: SequenceLikelihood.UNLIKELY,  # 'æ'
        22: SequenceLikelihood.UNLIKELY,  # 'ø'
    },
    14: {  # 'v'
        27: SequenceLikelihood.UNLIKELY,  # 'A'
        35: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        25: SequenceLikelihood.UNLIKELY,  # 'D'
        30: SequenceLikelihood.UNLIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        29: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        38: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        28: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.UNLIKELY,  # 'O'
        39: SequenceLikelihood.UNLIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        24: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        47: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        49: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        7: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.LIKELY,  # 'b'
        26: SequenceLikelihood.UNLIKELY,  # 'c'
        10: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        16: SequenceLikelihood.LIKELY,  # 'f'
        11: SequenceLikelihood.POSITIVE,  # 'g'
        20: SequenceLikelihood.POSITIVE,  # 'h'
        5: SequenceLikelihood.POSITIVE,  # 'i'
        21: SequenceLikelihood.LIKELY,  # 'j'
        12: SequenceLikelihood.LIKELY,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.LIKELY,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        9: SequenceLikelihood.POSITIVE,  # 'o'
        15: SequenceLikelihood.LIKELY,  # 'p'
        55: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.POSITIVE,  # 'r'
        6: SequenceLikelihood.POSITIVE,  # 's'
        3: SequenceLikelihood.POSITIVE,  # 't'
        17: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.LIKELY,  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'w'
        48: SequenceLikelihood.UNLIKELY,  # 'x'
        23: SequenceLikelihood.UNLIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        51: SequenceLikelihood.UNLIKELY,  # 'Å'
        58: SequenceLikelihood.UNLIKELY,  # 'Æ'
        52: SequenceLikelihood.UNLIKELY,  # 'Ø'
        18: SequenceLikelihood.POSITIVE,  # 'å'
        31: SequenceLikelihood.POSITIVE,  # 'æ'
        22: SequenceLikelihood.LIKELY,  # 'ø'
    },
    46: {  # 'w'
        27: SequenceLikelihood.UNLIKELY,  # 'A'
        35: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        25: SequenceLikelihood.UNLIKELY,  # 'D'
        30: SequenceLikelihood.UNLIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        29: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        38: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        28: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.UNLIKELY,  # 'O'
        39: SequenceLikelihood.UNLIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        24: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        47: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        49: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        7: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        26: SequenceLikelihood.UNLIKELY,  # 'c'
        10: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        16: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.LIKELY,  # 'h'
        5: SequenceLikelihood.POSITIVE,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        12: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.LIKELY,  # 'n'
        9: SequenceLikelihood.LIKELY,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        55: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.UNLIKELY,  # 'r'
        6: SequenceLikelihood.LIKELY,  # 's'
        3: SequenceLikelihood.UNLIKELY,  # 't'
        17: SequenceLikelihood.UNLIKELY,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        46: SequenceLikelihood.LIKELY,  # 'w'
        48: SequenceLikelihood.UNLIKELY,  # 'x'
        23: SequenceLikelihood.UNLIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        51: SequenceLikelihood.NEGATIVE,  # 'Å'
        58: SequenceLikelihood.NEGATIVE,  # 'Æ'
        52: SequenceLikelihood.NEGATIVE,  # 'Ø'
        18: SequenceLikelihood.UNLIKELY,  # 'å'
        31: SequenceLikelihood.UNLIKELY,  # 'æ'
        22: SequenceLikelihood.UNLIKELY,  # 'ø'
    },
    48: {  # 'x'
        27: SequenceLikelihood.UNLIKELY,  # 'A'
        35: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        25: SequenceLikelihood.UNLIKELY,  # 'D'
        30: SequenceLikelihood.UNLIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        29: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        38: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        28: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.UNLIKELY,  # 'O'
        39: SequenceLikelihood.UNLIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        24: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        47: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        49: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        7: SequenceLikelihood.LIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        26: SequenceLikelihood.LIKELY,  # 'c'
        10: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.LIKELY,  # 'e'
        16: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.LIKELY,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        12: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        9: SequenceLikelihood.LIKELY,  # 'o'
        15: SequenceLikelihood.LIKELY,  # 'p'
        55: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.UNLIKELY,  # 'r'
        6: SequenceLikelihood.UNLIKELY,  # 's'
        3: SequenceLikelihood.LIKELY,  # 't'
        17: SequenceLikelihood.UNLIKELY,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'w'
        48: SequenceLikelihood.LIKELY,  # 'x'
        23: SequenceLikelihood.LIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        51: SequenceLikelihood.UNLIKELY,  # 'Å'
        58: SequenceLikelihood.NEGATIVE,  # 'Æ'
        52: SequenceLikelihood.NEGATIVE,  # 'Ø'
        18: SequenceLikelihood.UNLIKELY,  # 'å'
        31: SequenceLikelihood.NEGATIVE,  # 'æ'
        22: SequenceLikelihood.UNLIKELY,  # 'ø'
    },
    23: {  # 'y'
        27: SequenceLikelihood.UNLIKELY,  # 'A'
        35: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        25: SequenceLikelihood.UNLIKELY,  # 'D'
        30: SequenceLikelihood.UNLIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        29: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        38: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        28: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.UNLIKELY,  # 'O'
        39: SequenceLikelihood.UNLIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        24: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        47: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        49: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        7: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.LIKELY,  # 'b'
        26: SequenceLikelihood.LIKELY,  # 'c'
        10: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        16: SequenceLikelihood.LIKELY,  # 'f'
        11: SequenceLikelihood.POSITIVE,  # 'g'
        20: SequenceLikelihood.LIKELY,  # 'h'
        5: SequenceLikelihood.LIKELY,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        12: SequenceLikelihood.POSITIVE,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        9: SequenceLikelihood.LIKELY,  # 'o'
        15: SequenceLikelihood.POSITIVE,  # 'p'
        55: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.POSITIVE,  # 'r'
        6: SequenceLikelihood.POSITIVE,  # 's'
        3: SequenceLikelihood.POSITIVE,  # 't'
        17: SequenceLikelihood.LIKELY,  # 'u'
        14: SequenceLikelihood.LIKELY,  # 'v'
        46: SequenceLikelihood.LIKELY,  # 'w'
        48: SequenceLikelihood.UNLIKELY,  # 'x'
        23: SequenceLikelihood.UNLIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        51: SequenceLikelihood.UNLIKELY,  # 'Å'
        58: SequenceLikelihood.NEGATIVE,  # 'Æ'
        52: SequenceLikelihood.NEGATIVE,  # 'Ø'
        18: SequenceLikelihood.UNLIKELY,  # 'å'
        31: SequenceLikelihood.UNLIKELY,  # 'æ'
        22: SequenceLikelihood.UNLIKELY,  # 'ø'
    },
    50: {  # 'z'
        27: SequenceLikelihood.UNLIKELY,  # 'A'
        35: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        25: SequenceLikelihood.UNLIKELY,  # 'D'
        30: SequenceLikelihood.UNLIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        29: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        38: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        28: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.UNLIKELY,  # 'O'
        39: SequenceLikelihood.UNLIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        24: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        47: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        49: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.UNLIKELY,  # 'Z'
        7: SequenceLikelihood.LIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        26: SequenceLikelihood.UNLIKELY,  # 'c'
        10: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.LIKELY,  # 'e'
        16: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.LIKELY,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        12: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        9: SequenceLikelihood.LIKELY,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        55: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.UNLIKELY,  # 'r'
        6: SequenceLikelihood.UNLIKELY,  # 's'
        3: SequenceLikelihood.UNLIKELY,  # 't'
        17: SequenceLikelihood.LIKELY,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'w'
        48: SequenceLikelihood.UNLIKELY,  # 'x'
        23: SequenceLikelihood.LIKELY,  # 'y'
        50: SequenceLikelihood.LIKELY,  # 'z'
        51: SequenceLikelihood.NEGATIVE,  # 'Å'
        58: SequenceLikelihood.NEGATIVE,  # 'Æ'
        52: SequenceLikelihood.NEGATIVE,  # 'Ø'
        18: SequenceLikelihood.UNLIKELY,  # 'å'
        31: SequenceLikelihood.UNLIKELY,  # 'æ'
        22: SequenceLikelihood.UNLIKELY,  # 'ø'
    },
    51: {  # 'Å'
        27: SequenceLikelihood.UNLIKELY,  # 'A'
        35: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        25: SequenceLikelihood.UNLIKELY,  # 'D'
        30: SequenceLikelihood.UNLIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        29: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        38: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        28: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.UNLIKELY,  # 'O'
        39: SequenceLikelihood.UNLIKELY,  # 'P'
        57: SequenceLikelihood.NEGATIVE,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        24: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        47: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        49: SequenceLikelihood.NEGATIVE,  # 'W'
        54: SequenceLikelihood.NEGATIVE,  # 'X'
        53: SequenceLikelihood.NEGATIVE,  # 'Y'
        56: SequenceLikelihood.NEGATIVE,  # 'Z'
        7: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        26: SequenceLikelihood.NEGATIVE,  # 'c'
        10: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        16: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.UNLIKELY,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        12: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.LIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        9: SequenceLikelihood.NEGATIVE,  # 'o'
        15: SequenceLikelihood.LIKELY,  # 'p'
        55: SequenceLikelihood.NEGATIVE,  # 'q'
        2: SequenceLikelihood.LIKELY,  # 'r'
        6: SequenceLikelihood.LIKELY,  # 's'
        3: SequenceLikelihood.UNLIKELY,  # 't'
        17: SequenceLikelihood.NEGATIVE,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        46: SequenceLikelihood.NEGATIVE,  # 'w'
        48: SequenceLikelihood.NEGATIVE,  # 'x'
        23: SequenceLikelihood.NEGATIVE,  # 'y'
        50: SequenceLikelihood.NEGATIVE,  # 'z'
        51: SequenceLikelihood.UNLIKELY,  # 'Å'
        58: SequenceLikelihood.NEGATIVE,  # 'Æ'
        52: SequenceLikelihood.UNLIKELY,  # 'Ø'
        18: SequenceLikelihood.UNLIKELY,  # 'å'
        31: SequenceLikelihood.NEGATIVE,  # 'æ'
        22: SequenceLikelihood.NEGATIVE,  # 'ø'
    },
    58: {  # 'Æ'
        27: SequenceLikelihood.NEGATIVE,  # 'A'
        35: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.NEGATIVE,  # 'C'
        25: SequenceLikelihood.UNLIKELY,  # 'D'
        30: SequenceLikelihood.NEGATIVE,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        29: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.NEGATIVE,  # 'J'
        38: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        28: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.NEGATIVE,  # 'O'
        39: SequenceLikelihood.UNLIKELY,  # 'P'
        57: SequenceLikelihood.NEGATIVE,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        24: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        47: SequenceLikelihood.NEGATIVE,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        49: SequenceLikelihood.NEGATIVE,  # 'W'
        54: SequenceLikelihood.NEGATIVE,  # 'X'
        53: SequenceLikelihood.NEGATIVE,  # 'Y'
        56: SequenceLikelihood.NEGATIVE,  # 'Z'
        7: SequenceLikelihood.NEGATIVE,  # 'a'
        19: SequenceLikelihood.NEGATIVE,  # 'b'
        26: SequenceLikelihood.NEGATIVE,  # 'c'
        10: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.NEGATIVE,  # 'e'
        16: SequenceLikelihood.NEGATIVE,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.UNLIKELY,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        12: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        9: SequenceLikelihood.UNLIKELY,  # 'o'
        15: SequenceLikelihood.NEGATIVE,  # 'p'
        55: SequenceLikelihood.NEGATIVE,  # 'q'
        2: SequenceLikelihood.UNLIKELY,  # 'r'
        6: SequenceLikelihood.UNLIKELY,  # 's'
        3: SequenceLikelihood.UNLIKELY,  # 't'
        17: SequenceLikelihood.NEGATIVE,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        46: SequenceLikelihood.NEGATIVE,  # 'w'
        48: SequenceLikelihood.NEGATIVE,  # 'x'
        23: SequenceLikelihood.UNLIKELY,  # 'y'
        50: SequenceLikelihood.NEGATIVE,  # 'z'
        51: SequenceLikelihood.NEGATIVE,  # 'Å'
        58: SequenceLikelihood.UNLIKELY,  # 'Æ'
        52: SequenceLikelihood.UNLIKELY,  # 'Ø'
        18: SequenceLikelihood.NEGATIVE,  # 'å'
        31: SequenceLikelihood.UNLIKELY,  # 'æ'
        22: SequenceLikelihood.NEGATIVE,  # 'ø'
    },
    52: {  # 'Ø'
        27: SequenceLikelihood.UNLIKELY,  # 'A'
        35: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        25: SequenceLikelihood.UNLIKELY,  # 'D'
        30: SequenceLikelihood.UNLIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        29: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        38: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        28: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.UNLIKELY,  # 'O'
        39: SequenceLikelihood.UNLIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.LIKELY,  # 'R'
        24: SequenceLikelihood.LIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        47: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        49: SequenceLikelihood.UNLIKELY,  # 'W'
        54: SequenceLikelihood.NEGATIVE,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.NEGATIVE,  # 'Z'
        7: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        26: SequenceLikelihood.UNLIKELY,  # 'c'
        10: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        16: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.UNLIKELY,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        12: SequenceLikelihood.LIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.LIKELY,  # 'n'
        9: SequenceLikelihood.NEGATIVE,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        55: SequenceLikelihood.NEGATIVE,  # 'q'
        2: SequenceLikelihood.LIKELY,  # 'r'
        6: SequenceLikelihood.LIKELY,  # 's'
        3: SequenceLikelihood.UNLIKELY,  # 't'
        17: SequenceLikelihood.UNLIKELY,  # 'u'
        14: SequenceLikelihood.LIKELY,  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'w'
        48: SequenceLikelihood.UNLIKELY,  # 'x'
        23: SequenceLikelihood.LIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        51: SequenceLikelihood.UNLIKELY,  # 'Å'
        58: SequenceLikelihood.UNLIKELY,  # 'Æ'
        52: SequenceLikelihood.UNLIKELY,  # 'Ø'
        18: SequenceLikelihood.NEGATIVE,  # 'å'
        31: SequenceLikelihood.NEGATIVE,  # 'æ'
        22: SequenceLikelihood.UNLIKELY,  # 'ø'
    },
    18: {  # 'å'
        27: SequenceLikelihood.UNLIKELY,  # 'A'
        35: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        25: SequenceLikelihood.UNLIKELY,  # 'D'
        30: SequenceLikelihood.UNLIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        29: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        38: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        28: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.UNLIKELY,  # 'O'
        39: SequenceLikelihood.UNLIKELY,  # 'P'
        57: SequenceLikelihood.UNLIKELY,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        24: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        47: SequenceLikelihood.NEGATIVE,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        49: SequenceLikelihood.NEGATIVE,  # 'W'
        54: SequenceLikelihood.NEGATIVE,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.NEGATIVE,  # 'Z'
        7: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.LIKELY,  # 'b'
        26: SequenceLikelihood.UNLIKELY,  # 'c'
        10: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        16: SequenceLikelihood.LIKELY,  # 'f'
        11: SequenceLikelihood.LIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.UNLIKELY,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        12: SequenceLikelihood.POSITIVE,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.LIKELY,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        9: SequenceLikelihood.UNLIKELY,  # 'o'
        15: SequenceLikelihood.POSITIVE,  # 'p'
        55: SequenceLikelihood.NEGATIVE,  # 'q'
        2: SequenceLikelihood.POSITIVE,  # 'r'
        6: SequenceLikelihood.POSITIVE,  # 's'
        3: SequenceLikelihood.POSITIVE,  # 't'
        17: SequenceLikelihood.UNLIKELY,  # 'u'
        14: SequenceLikelihood.POSITIVE,  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'w'
        48: SequenceLikelihood.UNLIKELY,  # 'x'
        23: SequenceLikelihood.UNLIKELY,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        51: SequenceLikelihood.NEGATIVE,  # 'Å'
        58: SequenceLikelihood.UNLIKELY,  # 'Æ'
        52: SequenceLikelihood.UNLIKELY,  # 'Ø'
        18: SequenceLikelihood.UNLIKELY,  # 'å'
        31: SequenceLikelihood.UNLIKELY,  # 'æ'
        22: SequenceLikelihood.UNLIKELY,  # 'ø'
    },
    31: {  # 'æ'
        27: SequenceLikelihood.NEGATIVE,  # 'A'
        35: SequenceLikelihood.NEGATIVE,  # 'B'
        44: SequenceLikelihood.NEGATIVE,  # 'C'
        25: SequenceLikelihood.NEGATIVE,  # 'D'
        30: SequenceLikelihood.NEGATIVE,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.NEGATIVE,  # 'G'
        29: SequenceLikelihood.NEGATIVE,  # 'H'
        36: SequenceLikelihood.NEGATIVE,  # 'I'
        45: SequenceLikelihood.NEGATIVE,  # 'J'
        38: SequenceLikelihood.NEGATIVE,  # 'K'
        40: SequenceLikelihood.NEGATIVE,  # 'L'
        32: SequenceLikelihood.NEGATIVE,  # 'M'
        28: SequenceLikelihood.NEGATIVE,  # 'N'
        42: SequenceLikelihood.NEGATIVE,  # 'O'
        39: SequenceLikelihood.NEGATIVE,  # 'P'
        57: SequenceLikelihood.NEGATIVE,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        24: SequenceLikelihood.NEGATIVE,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        47: SequenceLikelihood.NEGATIVE,  # 'U'
        37: SequenceLikelihood.NEGATIVE,  # 'V'
        49: SequenceLikelihood.NEGATIVE,  # 'W'
        54: SequenceLikelihood.NEGATIVE,  # 'X'
        53: SequenceLikelihood.NEGATIVE,  # 'Y'
        56: SequenceLikelihood.NEGATIVE,  # 'Z'
        7: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        26: SequenceLikelihood.UNLIKELY,  # 'c'
        10: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        16: SequenceLikelihood.UNLIKELY,  # 'f'
        11: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.UNLIKELY,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        12: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.LIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        9: SequenceLikelihood.UNLIKELY,  # 'o'
        15: SequenceLikelihood.UNLIKELY,  # 'p'
        55: SequenceLikelihood.NEGATIVE,  # 'q'
        2: SequenceLikelihood.POSITIVE,  # 'r'
        6: SequenceLikelihood.LIKELY,  # 's'
        3: SequenceLikelihood.LIKELY,  # 't'
        17: SequenceLikelihood.UNLIKELY,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        46: SequenceLikelihood.NEGATIVE,  # 'w'
        48: SequenceLikelihood.UNLIKELY,  # 'x'
        23: SequenceLikelihood.NEGATIVE,  # 'y'
        50: SequenceLikelihood.NEGATIVE,  # 'z'
        51: SequenceLikelihood.UNLIKELY,  # 'Å'
        58: SequenceLikelihood.NEGATIVE,  # 'Æ'
        52: SequenceLikelihood.NEGATIVE,  # 'Ø'
        18: SequenceLikelihood.UNLIKELY,  # 'å'
        31: SequenceLikelihood.UNLIKELY,  # 'æ'
        22: SequenceLikelihood.UNLIKELY,  # 'ø'
    },
    22: {  # 'ø'
        27: SequenceLikelihood.UNLIKELY,  # 'A'
        35: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.NEGATIVE,  # 'C'
        25: SequenceLikelihood.UNLIKELY,  # 'D'
        30: SequenceLikelihood.UNLIKELY,  # 'E'
        34: SequenceLikelihood.UNLIKELY,  # 'F'
        43: SequenceLikelihood.UNLIKELY,  # 'G'
        29: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        45: SequenceLikelihood.UNLIKELY,  # 'J'
        38: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        28: SequenceLikelihood.UNLIKELY,  # 'N'
        42: SequenceLikelihood.UNLIKELY,  # 'O'
        39: SequenceLikelihood.UNLIKELY,  # 'P'
        57: SequenceLikelihood.NEGATIVE,  # 'Q'
        41: SequenceLikelihood.UNLIKELY,  # 'R'
        24: SequenceLikelihood.UNLIKELY,  # 'S'
        33: SequenceLikelihood.UNLIKELY,  # 'T'
        47: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        49: SequenceLikelihood.NEGATIVE,  # 'W'
        54: SequenceLikelihood.UNLIKELY,  # 'X'
        53: SequenceLikelihood.UNLIKELY,  # 'Y'
        56: SequenceLikelihood.NEGATIVE,  # 'Z'
        7: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.LIKELY,  # 'b'
        26: SequenceLikelihood.UNLIKELY,  # 'c'
        10: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.LIKELY,  # 'e'
        16: SequenceLikelihood.POSITIVE,  # 'f'
        11: SequenceLikelihood.LIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.LIKELY,  # 'i'
        21: SequenceLikelihood.UNLIKELY,  # 'j'
        12: SequenceLikelihood.POSITIVE,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        9: SequenceLikelihood.UNLIKELY,  # 'o'
        15: SequenceLikelihood.POSITIVE,  # 'p'
        55: SequenceLikelihood.UNLIKELY,  # 'q'
        2: SequenceLikelihood.POSITIVE,  # 'r'
        6: SequenceLikelihood.POSITIVE,  # 's'
        3: SequenceLikelihood.POSITIVE,  # 't'
        17: SequenceLikelihood.UNLIKELY,  # 'u'
        14: SequenceLikelihood.POSITIVE,  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'w'
        48: SequenceLikelihood.UNLIKELY,  # 'x'
        23: SequenceLikelihood.POSITIVE,  # 'y'
        50: SequenceLikelihood.UNLIKELY,  # 'z'
        51: SequenceLikelihood.NEGATIVE,  # 'Å'
        58: SequenceLikelihood.NEGATIVE,  # 'Æ'
        52: SequenceLikelihood.NEGATIVE,  # 'Ø'
        18: SequenceLikelihood.UNLIKELY,  # 'å'
        31: SequenceLikelihood.NEGATIVE,  # 'æ'
        22: SequenceLikelihood.UNLIKELY,  # 'ø'
    },
}

# Character Mapping Table(s):
CP037_NORWEGIAN_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x9c'
    5: CharacterCategory.CONTROL,  # '\t'
    6: CharacterCategory.CONTROL,  # '\x86'
    7: CharacterCategory.CONTROL,  # '\x7f'
    8: CharacterCategory.CONTROL,  # '\x97'
    9: CharacterCategory.CONTROL,  # '\x8d'
    10: CharacterCategory.CONTROL,  # '\x8e'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x9d'
    21: CharacterCategory.CONTROL,  # '\x85'
    22: CharacterCategory.CONTROL,  # '\x08'
    23: CharacterCategory.CONTROL,  # '\x87'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x92'
    27: CharacterCategory.CONTROL,  # '\x8f'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # '\x80'
    33: CharacterCategory.CONTROL,  # '\x81'
    34: CharacterCategory.CONTROL,  # '\x82'
    35: CharacterCategory.CONTROL,  # '\x83'
    36: CharacterCategory.CONTROL,  # '\x84'
    37: CharacterCategory.LINE_BREAK,  # '\n'
    38: CharacterCategory.CONTROL,  # '\x17'
    39: CharacterCategory.CONTROL,  # '\x1b'
    40: CharacterCategory.CONTROL,  # '\x88'
    41: CharacterCategory.CONTROL,  # '\x89'
    42: CharacterCategory.CONTROL,  # '\x8a'
    43: CharacterCategory.CONTROL,  # '\x8b'
    44: CharacterCategory.CONTROL,  # '\x8c'
    45: CharacterCategory.CONTROL,  # '\x05'
    46: CharacterCategory.CONTROL,  # '\x06'
    47: CharacterCategory.CONTROL,  # '\x07'
    48: CharacterCategory.CONTROL,  # '\x90'
    49: CharacterCategory.CONTROL,  # '\x91'
    50: CharacterCategory.CONTROL,  # '\x16'
    51: CharacterCategory.CONTROL,  # '\x93'
    52: CharacterCategory.CONTROL,  # '\x94'
    53: CharacterCategory.CONTROL,  # '\x95'
    54: CharacterCategory.CONTROL,  # '\x96'
    55: CharacterCategory.CONTROL,  # '\x04'
    56: CharacterCategory.CONTROL,  # '\x98'
    57: CharacterCategory.CONTROL,  # '\x99'
    58: CharacterCategory.CONTROL,  # '\x9a'
    59: CharacterCategory.CONTROL,  # '\x9b'
    60: CharacterCategory.CONTROL,  # '\x14'
    61: CharacterCategory.CONTROL,  # '\x15'
    62: CharacterCategory.CONTROL,  # '\x9e'
    63: CharacterCategory.CONTROL,  # '\x1a'
    64: CharacterCategory.CONTROL,  # ' '
    65: CharacterCategory.CONTROL,  # '\xa0'
    66: 0,  # 'â'
    67: 0,  # 'ä'
    68: 0,  # 'à'
    69: 0,  # 'á'
    70: 0,  # 'ã'
    71: 18,  # 'å'
    72: 0,  # 'ç'
    73: 0,  # 'ñ'
    74: CharacterCategory.SYMBOL,  # '¢'
    75: CharacterCategory.SYMBOL,  # '.'
    76: CharacterCategory.SYMBOL,  # '<'
    77: CharacterCategory.SYMBOL,  # '('
    78: CharacterCategory.SYMBOL,  # '+'
    79: CharacterCategory.SYMBOL,  # '|'
    80: CharacterCategory.SYMBOL,  # '&'
    81: 0,  # 'é'
    82: 0,  # 'ê'
    83: 0,  # 'ë'
    84: 0,  # 'è'
    85: 0,  # 'í'
    86: 0,  # 'î'
    87: 0,  # 'ï'
    88: 0,  # 'ì'
    89: 0,  # 'ß'
    90: CharacterCategory.SYMBOL,  # '!'
    91: CharacterCategory.SYMBOL,  # '$'
    92: CharacterCategory.SYMBOL,  # '*'
    93: CharacterCategory.SYMBOL,  # ')'
    94: CharacterCategory.SYMBOL,  # ';'
    95: CharacterCategory.SYMBOL,  # '¬'
    96: CharacterCategory.SYMBOL,  # '-'
    97: CharacterCategory.SYMBOL,  # '/'
    98: 0,  # 'Â'
    99: 0,  # 'Ä'
    100: 0,  # 'À'
    101: 0,  # 'Á'
    102: 0,  # 'Ã'
    103: 51,  # 'Å'
    104: 0,  # 'Ç'
    105: 0,  # 'Ñ'
    106: CharacterCategory.SYMBOL,  # '¦'
    107: CharacterCategory.SYMBOL,  # ','
    108: CharacterCategory.SYMBOL,  # '%'
    109: CharacterCategory.SYMBOL,  # '_'
    110: CharacterCategory.SYMBOL,  # '>'
    111: CharacterCategory.SYMBOL,  # '?'
    112: 22,  # 'ø'
    113: 0,  # 'É'
    114: 0,  # 'Ê'
    115: 0,  # 'Ë'
    116: 0,  # 'È'
    117: 0,  # 'Í'
    118: 0,  # 'Î'
    119: 0,  # 'Ï'
    120: 0,  # 'Ì'
    121: CharacterCategory.SYMBOL,  # '`'
    122: CharacterCategory.SYMBOL,  # ':'
    123: CharacterCategory.SYMBOL,  # '#'
    124: CharacterCategory.SYMBOL,  # '@'
    125: CharacterCategory.SYMBOL,  # "'"
    126: CharacterCategory.SYMBOL,  # '='
    127: CharacterCategory.SYMBOL,  # '"'
    128: 52,  # 'Ø'
    129: 7,  # 'a'
    130: 19,  # 'b'
    131: 26,  # 'c'
    132: 10,  # 'd'
    133: 1,  # 'e'
    134: 16,  # 'f'
    135: 11,  # 'g'
    136: 20,  # 'h'
    137: 5,  # 'i'
    138: CharacterCategory.SYMBOL,  # '«'
    139: CharacterCategory.SYMBOL,  # '»'
    140: 0,  # 'ð'
    141: 0,  # 'ý'
    142: 0,  # 'þ'
    143: CharacterCategory.SYMBOL,  # '±'
    144: CharacterCategory.SYMBOL,  # '°'
    145: 21,  # 'j'
    146: 12,  # 'k'
    147: 8,  # 'l'
    148: 13,  # 'm'
    149: 4,  # 'n'
    150: 9,  # 'o'
    151: 15,  # 'p'
    152: 55,  # 'q'
    153: 2,  # 'r'
    154: 0,  # 'ª'
    155: 0,  # 'º'
    156: 31,  # 'æ'
    157: CharacterCategory.SYMBOL,  # '¸'
    158: 58,  # 'Æ'
    159: CharacterCategory.SYMBOL,  # '¤'
    160: 0,  # 'µ'
    161: CharacterCategory.SYMBOL,  # '~'
    162: 6,  # 's'
    163: 3,  # 't'
    164: 17,  # 'u'
    165: 14,  # 'v'
    166: 46,  # 'w'
    167: 48,  # 'x'
    168: 23,  # 'y'
    169: 50,  # 'z'
    170: CharacterCategory.SYMBOL,  # '¡'
    171: CharacterCategory.SYMBOL,  # '¿'
    172: 0,  # 'Ð'
    173: 0,  # 'Ý'
    174: 0,  # 'Þ'
    175: CharacterCategory.SYMBOL,  # '®'
    176: CharacterCategory.SYMBOL,  # '^'
    177: CharacterCategory.SYMBOL,  # '£'
    178: CharacterCategory.SYMBOL,  # '¥'
    179: CharacterCategory.SYMBOL,  # '·'
    180: CharacterCategory.SYMBOL,  # '©'
    181: CharacterCategory.SYMBOL,  # '§'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.DIGIT,  # '¼'
    184: CharacterCategory.DIGIT,  # '½'
    185: CharacterCategory.DIGIT,  # '¾'
    186: CharacterCategory.SYMBOL,  # '['
    187: CharacterCategory.SYMBOL,  # ']'
    188: CharacterCategory.SYMBOL,  # '¯'
    189: CharacterCategory.SYMBOL,  # '¨'
    190: CharacterCategory.SYMBOL,  # '´'
    191: CharacterCategory.SYMBOL,  # '×'
    192: CharacterCategory.SYMBOL,  # '{'
    193: 27,  # 'A'
    194: 35,  # 'B'
    195: 44,  # 'C'
    196: 25,  # 'D'
    197: 30,  # 'E'
    198: 34,  # 'F'
    199: 43,  # 'G'
    200: 29,  # 'H'
    201: 36,  # 'I'
    202: CharacterCategory.CONTROL,  # '\xad'
    203: 0,  # 'ô'
    204: 0,  # 'ö'
    205: 0,  # 'ò'
    206: 0,  # 'ó'
    207: 0,  # 'õ'
    208: CharacterCategory.SYMBOL,  # '}'
    209: 45,  # 'J'
    210: 38,  # 'K'
    211: 40,  # 'L'
    212: 32,  # 'M'
    213: 28,  # 'N'
    214: 42,  # 'O'
    215: 39,  # 'P'
    216: 57,  # 'Q'
    217: 41,  # 'R'
    218: CharacterCategory.DIGIT,  # '¹'
    219: 0,  # 'û'
    220: 0,  # 'ü'
    221: 0,  # 'ù'
    222: 0,  # 'ú'
    223: 0,  # 'ÿ'
    224: CharacterCategory.SYMBOL,  # '\\'
    225: CharacterCategory.SYMBOL,  # '÷'
    226: 24,  # 'S'
    227: 33,  # 'T'
    228: 47,  # 'U'
    229: 37,  # 'V'
    230: 49,  # 'W'
    231: 54,  # 'X'
    232: 53,  # 'Y'
    233: 56,  # 'Z'
    234: CharacterCategory.DIGIT,  # '²'
    235: 0,  # 'Ô'
    236: 0,  # 'Ö'
    237: 0,  # 'Ò'
    238: 0,  # 'Ó'
    239: 0,  # 'Õ'
    240: CharacterCategory.DIGIT,  # '0'
    241: CharacterCategory.DIGIT,  # '1'
    242: CharacterCategory.DIGIT,  # '2'
    243: CharacterCategory.DIGIT,  # '3'
    244: CharacterCategory.DIGIT,  # '4'
    245: CharacterCategory.DIGIT,  # '5'
    246: CharacterCategory.DIGIT,  # '6'
    247: CharacterCategory.DIGIT,  # '7'
    248: CharacterCategory.DIGIT,  # '8'
    249: CharacterCategory.DIGIT,  # '9'
    250: CharacterCategory.DIGIT,  # '³'
    251: 0,  # 'Û'
    252: 0,  # 'Ü'
    253: 0,  # 'Ù'
    254: 0,  # 'Ú'
    255: CharacterCategory.CONTROL,  # '\x9f'
}

CP037_NORWEGIAN_MODEL = SingleByteCharSetModel(
    charset_name="CP037",
    language="Norwegian",
    char_to_order_map=CP037_NORWEGIAN_CHAR_TO_ORDER,
    language_model=NORWEGIAN_LANG_MODEL,
    typical_positive_ratio=0.9785657009892291,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÅÆØåæø",
)

CP437_NORWEGIAN_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 27,  # 'A'
    66: 35,  # 'B'
    67: 44,  # 'C'
    68: 25,  # 'D'
    69: 30,  # 'E'
    70: 34,  # 'F'
    71: 43,  # 'G'
    72: 29,  # 'H'
    73: 36,  # 'I'
    74: 45,  # 'J'
    75: 38,  # 'K'
    76: 40,  # 'L'
    77: 32,  # 'M'
    78: 28,  # 'N'
    79: 42,  # 'O'
    80: 39,  # 'P'
    81: 57,  # 'Q'
    82: 41,  # 'R'
    83: 24,  # 'S'
    84: 33,  # 'T'
    85: 47,  # 'U'
    86: 37,  # 'V'
    87: 49,  # 'W'
    88: 54,  # 'X'
    89: 53,  # 'Y'
    90: 56,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 7,  # 'a'
    98: 19,  # 'b'
    99: 26,  # 'c'
    100: 10,  # 'd'
    101: 1,  # 'e'
    102: 16,  # 'f'
    103: 11,  # 'g'
    104: 20,  # 'h'
    105: 5,  # 'i'
    106: 21,  # 'j'
    107: 12,  # 'k'
    108: 8,  # 'l'
    109: 13,  # 'm'
    110: 4,  # 'n'
    111: 9,  # 'o'
    112: 15,  # 'p'
    113: 55,  # 'q'
    114: 2,  # 'r'
    115: 6,  # 's'
    116: 3,  # 't'
    117: 17,  # 'u'
    118: 14,  # 'v'
    119: 46,  # 'w'
    120: 48,  # 'x'
    121: 23,  # 'y'
    122: 50,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 0,  # 'Ç'
    129: 0,  # 'ü'
    130: 0,  # 'é'
    131: 0,  # 'â'
    132: 0,  # 'ä'
    133: 0,  # 'à'
    134: 18,  # 'å'
    135: 0,  # 'ç'
    136: 0,  # 'ê'
    137: 0,  # 'ë'
    138: 0,  # 'è'
    139: 0,  # 'ï'
    140: 0,  # 'î'
    141: 0,  # 'ì'
    142: 0,  # 'Ä'
    143: 51,  # 'Å'
    144: 0,  # 'É'
    145: 31,  # 'æ'
    146: 58,  # 'Æ'
    147: 0,  # 'ô'
    148: 0,  # 'ö'
    149: 0,  # 'ò'
    150: 0,  # 'û'
    151: 0,  # 'ù'
    152: 0,  # 'ÿ'
    153: 0,  # 'Ö'
    154: 0,  # 'Ü'
    155: CharacterCategory.SYMBOL,  # '¢'
    156: CharacterCategory.SYMBOL,  # '£'
    157: CharacterCategory.SYMBOL,  # '¥'
    158: CharacterCategory.SYMBOL,  # '₧'
    159: 0,  # 'ƒ'
    160: 0,  # 'á'
    161: 0,  # 'í'
    162: 0,  # 'ó'
    163: 0,  # 'ú'
    164: 0,  # 'ñ'
    165: 0,  # 'Ñ'
    166: 0,  # 'ª'
    167: 0,  # 'º'
    168: CharacterCategory.SYMBOL,  # '¿'
    169: CharacterCategory.SYMBOL,  # '⌐'
    170: CharacterCategory.SYMBOL,  # '¬'
    171: CharacterCategory.DIGIT,  # '½'
    172: CharacterCategory.DIGIT,  # '¼'
    173: CharacterCategory.SYMBOL,  # '¡'
    174: CharacterCategory.SYMBOL,  # '«'
    175: CharacterCategory.SYMBOL,  # '»'
    176: CharacterCategory.SYMBOL,  # '░'
    177: CharacterCategory.SYMBOL,  # '▒'
    178: CharacterCategory.SYMBOL,  # '▓'
    179: CharacterCategory.SYMBOL,  # '│'
    180: CharacterCategory.SYMBOL,  # '┤'
    181: CharacterCategory.SYMBOL,  # '╡'
    182: CharacterCategory.SYMBOL,  # '╢'
    183: CharacterCategory.SYMBOL,  # '╖'
    184: CharacterCategory.SYMBOL,  # '╕'
    185: CharacterCategory.SYMBOL,  # '╣'
    186: CharacterCategory.SYMBOL,  # '║'
    187: CharacterCategory.SYMBOL,  # '╗'
    188: CharacterCategory.SYMBOL,  # '╝'
    189: CharacterCategory.SYMBOL,  # '╜'
    190: CharacterCategory.SYMBOL,  # '╛'
    191: CharacterCategory.SYMBOL,  # '┐'
    192: CharacterCategory.SYMBOL,  # '└'
    193: CharacterCategory.SYMBOL,  # '┴'
    194: CharacterCategory.SYMBOL,  # '┬'
    195: CharacterCategory.SYMBOL,  # '├'
    196: CharacterCategory.SYMBOL,  # '─'
    197: CharacterCategory.SYMBOL,  # '┼'
    198: CharacterCategory.SYMBOL,  # '╞'
    199: CharacterCategory.SYMBOL,  # '╟'
    200: CharacterCategory.SYMBOL,  # '╚'
    201: CharacterCategory.SYMBOL,  # '╔'
    202: CharacterCategory.SYMBOL,  # '╩'
    203: CharacterCategory.SYMBOL,  # '╦'
    204: CharacterCategory.SYMBOL,  # '╠'
    205: CharacterCategory.SYMBOL,  # '═'
    206: CharacterCategory.SYMBOL,  # '╬'
    207: CharacterCategory.SYMBOL,  # '╧'
    208: CharacterCategory.SYMBOL,  # '╨'
    209: CharacterCategory.SYMBOL,  # '╤'
    210: CharacterCategory.SYMBOL,  # '╥'
    211: CharacterCategory.SYMBOL,  # '╙'
    212: CharacterCategory.SYMBOL,  # '╘'
    213: CharacterCategory.SYMBOL,  # '╒'
    214: CharacterCategory.SYMBOL,  # '╓'
    215: CharacterCategory.SYMBOL,  # '╫'
    216: CharacterCategory.SYMBOL,  # '╪'
    217: CharacterCategory.SYMBOL,  # '┘'
    218: CharacterCategory.SYMBOL,  # '┌'
    219: CharacterCategory.SYMBOL,  # '█'
    220: CharacterCategory.SYMBOL,  # '▄'
    221: CharacterCategory.SYMBOL,  # '▌'
    222: CharacterCategory.SYMBOL,  # '▐'
    223: CharacterCategory.SYMBOL,  # '▀'
    224: 0,  # 'α'
    225: 0,  # 'ß'
    226: 0,  # 'Γ'
    227: 0,  # 'π'
    228: 0,  # 'Σ'
    229: 0,  # 'σ'
    230: 0,  # 'µ'
    231: 0,  # 'τ'
    232: 0,  # 'Φ'
    233: 0,  # 'Θ'
    234: 0,  # 'Ω'
    235: 0,  # 'δ'
    236: CharacterCategory.SYMBOL,  # '∞'
    237: 0,  # 'φ'
    238: 0,  # 'ε'
    239: CharacterCategory.SYMBOL,  # '∩'
    240: CharacterCategory.SYMBOL,  # '≡'
    241: CharacterCategory.SYMBOL,  # '±'
    242: CharacterCategory.SYMBOL,  # '≥'
    243: CharacterCategory.SYMBOL,  # '≤'
    244: CharacterCategory.SYMBOL,  # '⌠'
    245: CharacterCategory.SYMBOL,  # '⌡'
    246: CharacterCategory.SYMBOL,  # '÷'
    247: CharacterCategory.SYMBOL,  # '≈'
    248: CharacterCategory.SYMBOL,  # '°'
    249: CharacterCategory.SYMBOL,  # '∙'
    250: CharacterCategory.SYMBOL,  # '·'
    251: CharacterCategory.SYMBOL,  # '√'
    252: 0,  # 'ⁿ'
    253: CharacterCategory.DIGIT,  # '²'
    254: CharacterCategory.SYMBOL,  # '■'
    255: CharacterCategory.CONTROL,  # '\xa0'
}

CP437_NORWEGIAN_MODEL = SingleByteCharSetModel(
    charset_name="CP437",
    language="Norwegian",
    char_to_order_map=CP437_NORWEGIAN_CHAR_TO_ORDER,
    language_model=NORWEGIAN_LANG_MODEL,
    typical_positive_ratio=0.9792061674061758,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÅÆØåæø",
)

CP500_NORWEGIAN_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x9c'
    5: CharacterCategory.CONTROL,  # '\t'
    6: CharacterCategory.CONTROL,  # '\x86'
    7: CharacterCategory.CONTROL,  # '\x7f'
    8: CharacterCategory.CONTROL,  # '\x97'
    9: CharacterCategory.CONTROL,  # '\x8d'
    10: CharacterCategory.CONTROL,  # '\x8e'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x9d'
    21: CharacterCategory.CONTROL,  # '\x85'
    22: CharacterCategory.CONTROL,  # '\x08'
    23: CharacterCategory.CONTROL,  # '\x87'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x92'
    27: CharacterCategory.CONTROL,  # '\x8f'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # '\x80'
    33: CharacterCategory.CONTROL,  # '\x81'
    34: CharacterCategory.CONTROL,  # '\x82'
    35: CharacterCategory.CONTROL,  # '\x83'
    36: CharacterCategory.CONTROL,  # '\x84'
    37: CharacterCategory.LINE_BREAK,  # '\n'
    38: CharacterCategory.CONTROL,  # '\x17'
    39: CharacterCategory.CONTROL,  # '\x1b'
    40: CharacterCategory.CONTROL,  # '\x88'
    41: CharacterCategory.CONTROL,  # '\x89'
    42: CharacterCategory.CONTROL,  # '\x8a'
    43: CharacterCategory.CONTROL,  # '\x8b'
    44: CharacterCategory.CONTROL,  # '\x8c'
    45: CharacterCategory.CONTROL,  # '\x05'
    46: CharacterCategory.CONTROL,  # '\x06'
    47: CharacterCategory.CONTROL,  # '\x07'
    48: CharacterCategory.CONTROL,  # '\x90'
    49: CharacterCategory.CONTROL,  # '\x91'
    50: CharacterCategory.CONTROL,  # '\x16'
    51: CharacterCategory.CONTROL,  # '\x93'
    52: CharacterCategory.CONTROL,  # '\x94'
    53: CharacterCategory.CONTROL,  # '\x95'
    54: CharacterCategory.CONTROL,  # '\x96'
    55: CharacterCategory.CONTROL,  # '\x04'
    56: CharacterCategory.CONTROL,  # '\x98'
    57: CharacterCategory.CONTROL,  # '\x99'
    58: CharacterCategory.CONTROL,  # '\x9a'
    59: CharacterCategory.CONTROL,  # '\x9b'
    60: CharacterCategory.CONTROL,  # '\x14'
    61: CharacterCategory.CONTROL,  # '\x15'
    62: CharacterCategory.CONTROL,  # '\x9e'
    63: CharacterCategory.CONTROL,  # '\x1a'
    64: CharacterCategory.CONTROL,  # ' '
    65: CharacterCategory.CONTROL,  # '\xa0'
    66: 0,  # 'â'
    67: 0,  # 'ä'
    68: 0,  # 'à'
    69: 0,  # 'á'
    70: 0,  # 'ã'
    71: 18,  # 'å'
    72: 0,  # 'ç'
    73: 0,  # 'ñ'
    74: CharacterCategory.SYMBOL,  # '['
    75: CharacterCategory.SYMBOL,  # '.'
    76: CharacterCategory.SYMBOL,  # '<'
    77: CharacterCategory.SYMBOL,  # '('
    78: CharacterCategory.SYMBOL,  # '+'
    79: CharacterCategory.SYMBOL,  # '!'
    80: CharacterCategory.SYMBOL,  # '&'
    81: 0,  # 'é'
    82: 0,  # 'ê'
    83: 0,  # 'ë'
    84: 0,  # 'è'
    85: 0,  # 'í'
    86: 0,  # 'î'
    87: 0,  # 'ï'
    88: 0,  # 'ì'
    89: 0,  # 'ß'
    90: CharacterCategory.SYMBOL,  # ']'
    91: CharacterCategory.SYMBOL,  # '$'
    92: CharacterCategory.SYMBOL,  # '*'
    93: CharacterCategory.SYMBOL,  # ')'
    94: CharacterCategory.SYMBOL,  # ';'
    95: CharacterCategory.SYMBOL,  # '^'
    96: CharacterCategory.SYMBOL,  # '-'
    97: CharacterCategory.SYMBOL,  # '/'
    98: 0,  # 'Â'
    99: 0,  # 'Ä'
    100: 0,  # 'À'
    101: 0,  # 'Á'
    102: 0,  # 'Ã'
    103: 51,  # 'Å'
    104: 0,  # 'Ç'
    105: 0,  # 'Ñ'
    106: CharacterCategory.SYMBOL,  # '¦'
    107: CharacterCategory.SYMBOL,  # ','
    108: CharacterCategory.SYMBOL,  # '%'
    109: CharacterCategory.SYMBOL,  # '_'
    110: CharacterCategory.SYMBOL,  # '>'
    111: CharacterCategory.SYMBOL,  # '?'
    112: 22,  # 'ø'
    113: 0,  # 'É'
    114: 0,  # 'Ê'
    115: 0,  # 'Ë'
    116: 0,  # 'È'
    117: 0,  # 'Í'
    118: 0,  # 'Î'
    119: 0,  # 'Ï'
    120: 0,  # 'Ì'
    121: CharacterCategory.SYMBOL,  # '`'
    122: CharacterCategory.SYMBOL,  # ':'
    123: CharacterCategory.SYMBOL,  # '#'
    124: CharacterCategory.SYMBOL,  # '@'
    125: CharacterCategory.SYMBOL,  # "'"
    126: CharacterCategory.SYMBOL,  # '='
    127: CharacterCategory.SYMBOL,  # '"'
    128: 52,  # 'Ø'
    129: 7,  # 'a'
    130: 19,  # 'b'
    131: 26,  # 'c'
    132: 10,  # 'd'
    133: 1,  # 'e'
    134: 16,  # 'f'
    135: 11,  # 'g'
    136: 20,  # 'h'
    137: 5,  # 'i'
    138: CharacterCategory.SYMBOL,  # '«'
    139: CharacterCategory.SYMBOL,  # '»'
    140: 0,  # 'ð'
    141: 0,  # 'ý'
    142: 0,  # 'þ'
    143: CharacterCategory.SYMBOL,  # '±'
    144: CharacterCategory.SYMBOL,  # '°'
    145: 21,  # 'j'
    146: 12,  # 'k'
    147: 8,  # 'l'
    148: 13,  # 'm'
    149: 4,  # 'n'
    150: 9,  # 'o'
    151: 15,  # 'p'
    152: 55,  # 'q'
    153: 2,  # 'r'
    154: 0,  # 'ª'
    155: 0,  # 'º'
    156: 31,  # 'æ'
    157: CharacterCategory.SYMBOL,  # '¸'
    158: 58,  # 'Æ'
    159: CharacterCategory.SYMBOL,  # '¤'
    160: 0,  # 'µ'
    161: CharacterCategory.SYMBOL,  # '~'
    162: 6,  # 's'
    163: 3,  # 't'
    164: 17,  # 'u'
    165: 14,  # 'v'
    166: 46,  # 'w'
    167: 48,  # 'x'
    168: 23,  # 'y'
    169: 50,  # 'z'
    170: CharacterCategory.SYMBOL,  # '¡'
    171: CharacterCategory.SYMBOL,  # '¿'
    172: 0,  # 'Ð'
    173: 0,  # 'Ý'
    174: 0,  # 'Þ'
    175: CharacterCategory.SYMBOL,  # '®'
    176: CharacterCategory.SYMBOL,  # '¢'
    177: CharacterCategory.SYMBOL,  # '£'
    178: CharacterCategory.SYMBOL,  # '¥'
    179: CharacterCategory.SYMBOL,  # '·'
    180: CharacterCategory.SYMBOL,  # '©'
    181: CharacterCategory.SYMBOL,  # '§'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.DIGIT,  # '¼'
    184: CharacterCategory.DIGIT,  # '½'
    185: CharacterCategory.DIGIT,  # '¾'
    186: CharacterCategory.SYMBOL,  # '¬'
    187: CharacterCategory.SYMBOL,  # '|'
    188: CharacterCategory.SYMBOL,  # '¯'
    189: CharacterCategory.SYMBOL,  # '¨'
    190: CharacterCategory.SYMBOL,  # '´'
    191: CharacterCategory.SYMBOL,  # '×'
    192: CharacterCategory.SYMBOL,  # '{'
    193: 27,  # 'A'
    194: 35,  # 'B'
    195: 44,  # 'C'
    196: 25,  # 'D'
    197: 30,  # 'E'
    198: 34,  # 'F'
    199: 43,  # 'G'
    200: 29,  # 'H'
    201: 36,  # 'I'
    202: CharacterCategory.CONTROL,  # '\xad'
    203: 0,  # 'ô'
    204: 0,  # 'ö'
    205: 0,  # 'ò'
    206: 0,  # 'ó'
    207: 0,  # 'õ'
    208: CharacterCategory.SYMBOL,  # '}'
    209: 45,  # 'J'
    210: 38,  # 'K'
    211: 40,  # 'L'
    212: 32,  # 'M'
    213: 28,  # 'N'
    214: 42,  # 'O'
    215: 39,  # 'P'
    216: 57,  # 'Q'
    217: 41,  # 'R'
    218: CharacterCategory.DIGIT,  # '¹'
    219: 0,  # 'û'
    220: 0,  # 'ü'
    221: 0,  # 'ù'
    222: 0,  # 'ú'
    223: 0,  # 'ÿ'
    224: CharacterCategory.SYMBOL,  # '\\'
    225: CharacterCategory.SYMBOL,  # '÷'
    226: 24,  # 'S'
    227: 33,  # 'T'
    228: 47,  # 'U'
    229: 37,  # 'V'
    230: 49,  # 'W'
    231: 54,  # 'X'
    232: 53,  # 'Y'
    233: 56,  # 'Z'
    234: CharacterCategory.DIGIT,  # '²'
    235: 0,  # 'Ô'
    236: 0,  # 'Ö'
    237: 0,  # 'Ò'
    238: 0,  # 'Ó'
    239: 0,  # 'Õ'
    240: CharacterCategory.DIGIT,  # '0'
    241: CharacterCategory.DIGIT,  # '1'
    242: CharacterCategory.DIGIT,  # '2'
    243: CharacterCategory.DIGIT,  # '3'
    244: CharacterCategory.DIGIT,  # '4'
    245: CharacterCategory.DIGIT,  # '5'
    246: CharacterCategory.DIGIT,  # '6'
    247: CharacterCategory.DIGIT,  # '7'
    248: CharacterCategory.DIGIT,  # '8'
    249: CharacterCategory.DIGIT,  # '9'
    250: CharacterCategory.DIGIT,  # '³'
    251: 0,  # 'Û'
    252: 0,  # 'Ü'
    253: 0,  # 'Ù'
    254: 0,  # 'Ú'
    255: CharacterCategory.CONTROL,  # '\x9f'
}

CP500_NORWEGIAN_MODEL = SingleByteCharSetModel(
    charset_name="CP500",
    language="Norwegian",
    char_to_order_map=CP500_NORWEGIAN_CHAR_TO_ORDER,
    language_model=NORWEGIAN_LANG_MODEL,
    typical_positive_ratio=0.9785657009892291,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÅÆØåæø",
)

CP850_NORWEGIAN_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 27,  # 'A'
    66: 35,  # 'B'
    67: 44,  # 'C'
    68: 25,  # 'D'
    69: 30,  # 'E'
    70: 34,  # 'F'
    71: 43,  # 'G'
    72: 29,  # 'H'
    73: 36,  # 'I'
    74: 45,  # 'J'
    75: 38,  # 'K'
    76: 40,  # 'L'
    77: 32,  # 'M'
    78: 28,  # 'N'
    79: 42,  # 'O'
    80: 39,  # 'P'
    81: 57,  # 'Q'
    82: 41,  # 'R'
    83: 24,  # 'S'
    84: 33,  # 'T'
    85: 47,  # 'U'
    86: 37,  # 'V'
    87: 49,  # 'W'
    88: 54,  # 'X'
    89: 53,  # 'Y'
    90: 56,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 7,  # 'a'
    98: 19,  # 'b'
    99: 26,  # 'c'
    100: 10,  # 'd'
    101: 1,  # 'e'
    102: 16,  # 'f'
    103: 11,  # 'g'
    104: 20,  # 'h'
    105: 5,  # 'i'
    106: 21,  # 'j'
    107: 12,  # 'k'
    108: 8,  # 'l'
    109: 13,  # 'm'
    110: 4,  # 'n'
    111: 9,  # 'o'
    112: 15,  # 'p'
    113: 55,  # 'q'
    114: 2,  # 'r'
    115: 6,  # 's'
    116: 3,  # 't'
    117: 17,  # 'u'
    118: 14,  # 'v'
    119: 46,  # 'w'
    120: 48,  # 'x'
    121: 23,  # 'y'
    122: 50,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 0,  # 'Ç'
    129: 0,  # 'ü'
    130: 0,  # 'é'
    131: 0,  # 'â'
    132: 0,  # 'ä'
    133: 0,  # 'à'
    134: 18,  # 'å'
    135: 0,  # 'ç'
    136: 0,  # 'ê'
    137: 0,  # 'ë'
    138: 0,  # 'è'
    139: 0,  # 'ï'
    140: 0,  # 'î'
    141: 0,  # 'ì'
    142: 0,  # 'Ä'
    143: 51,  # 'Å'
    144: 0,  # 'É'
    145: 31,  # 'æ'
    146: 58,  # 'Æ'
    147: 0,  # 'ô'
    148: 0,  # 'ö'
    149: 0,  # 'ò'
    150: 0,  # 'û'
    151: 0,  # 'ù'
    152: 0,  # 'ÿ'
    153: 0,  # 'Ö'
    154: 0,  # 'Ü'
    155: 22,  # 'ø'
    156: CharacterCategory.SYMBOL,  # '£'
    157: 52,  # 'Ø'
    158: CharacterCategory.SYMBOL,  # '×'
    159: 0,  # 'ƒ'
    160: 0,  # 'á'
    161: 0,  # 'í'
    162: 0,  # 'ó'
    163: 0,  # 'ú'
    164: 0,  # 'ñ'
    165: 0,  # 'Ñ'
    166: 0,  # 'ª'
    167: 0,  # 'º'
    168: CharacterCategory.SYMBOL,  # '¿'
    169: CharacterCategory.SYMBOL,  # '®'
    170: CharacterCategory.SYMBOL,  # '¬'
    171: CharacterCategory.DIGIT,  # '½'
    172: CharacterCategory.DIGIT,  # '¼'
    173: CharacterCategory.SYMBOL,  # '¡'
    174: CharacterCategory.SYMBOL,  # '«'
    175: CharacterCategory.SYMBOL,  # '»'
    176: CharacterCategory.SYMBOL,  # '░'
    177: CharacterCategory.SYMBOL,  # '▒'
    178: CharacterCategory.SYMBOL,  # '▓'
    179: CharacterCategory.SYMBOL,  # '│'
    180: CharacterCategory.SYMBOL,  # '┤'
    181: 0,  # 'Á'
    182: 0,  # 'Â'
    183: 0,  # 'À'
    184: CharacterCategory.SYMBOL,  # '©'
    185: CharacterCategory.SYMBOL,  # '╣'
    186: CharacterCategory.SYMBOL,  # '║'
    187: CharacterCategory.SYMBOL,  # '╗'
    188: CharacterCategory.SYMBOL,  # '╝'
    189: CharacterCategory.SYMBOL,  # '¢'
    190: CharacterCategory.SYMBOL,  # '¥'
    191: CharacterCategory.SYMBOL,  # '┐'
    192: CharacterCategory.SYMBOL,  # '└'
    193: CharacterCategory.SYMBOL,  # '┴'
    194: CharacterCategory.SYMBOL,  # '┬'
    195: CharacterCategory.SYMBOL,  # '├'
    196: CharacterCategory.SYMBOL,  # '─'
    197: CharacterCategory.SYMBOL,  # '┼'
    198: 0,  # 'ã'
    199: 0,  # 'Ã'
    200: CharacterCategory.SYMBOL,  # '╚'
    201: CharacterCategory.SYMBOL,  # '╔'
    202: CharacterCategory.SYMBOL,  # '╩'
    203: CharacterCategory.SYMBOL,  # '╦'
    204: CharacterCategory.SYMBOL,  # '╠'
    205: CharacterCategory.SYMBOL,  # '═'
    206: CharacterCategory.SYMBOL,  # '╬'
    207: CharacterCategory.SYMBOL,  # '¤'
    208: 0,  # 'ð'
    209: 0,  # 'Ð'
    210: 0,  # 'Ê'
    211: 0,  # 'Ë'
    212: 0,  # 'È'
    213: 0,  # 'ı'
    214: 0,  # 'Í'
    215: 0,  # 'Î'
    216: 0,  # 'Ï'
    217: CharacterCategory.SYMBOL,  # '┘'
    218: CharacterCategory.SYMBOL,  # '┌'
    219: CharacterCategory.SYMBOL,  # '█'
    220: CharacterCategory.SYMBOL,  # '▄'
    221: CharacterCategory.SYMBOL,  # '¦'
    222: 0,  # 'Ì'
    223: CharacterCategory.SYMBOL,  # '▀'
    224: 0,  # 'Ó'
    225: 0,  # 'ß'
    226: 0,  # 'Ô'
    227: 0,  # 'Ò'
    228: 0,  # 'õ'
    229: 0,  # 'Õ'
    230: 0,  # 'µ'
    231: 0,  # 'þ'
    232: 0,  # 'Þ'
    233: 0,  # 'Ú'
    234: 0,  # 'Û'
    235: 0,  # 'Ù'
    236: 0,  # 'ý'
    237: 0,  # 'Ý'
    238: CharacterCategory.SYMBOL,  # '¯'
    239: CharacterCategory.SYMBOL,  # '´'
    240: CharacterCategory.CONTROL,  # '\xad'
    241: CharacterCategory.SYMBOL,  # '±'
    242: CharacterCategory.SYMBOL,  # '‗'
    243: CharacterCategory.DIGIT,  # '¾'
    244: CharacterCategory.SYMBOL,  # '¶'
    245: CharacterCategory.SYMBOL,  # '§'
    246: CharacterCategory.SYMBOL,  # '÷'
    247: CharacterCategory.SYMBOL,  # '¸'
    248: CharacterCategory.SYMBOL,  # '°'
    249: CharacterCategory.SYMBOL,  # '¨'
    250: CharacterCategory.SYMBOL,  # '·'
    251: CharacterCategory.DIGIT,  # '¹'
    252: CharacterCategory.DIGIT,  # '³'
    253: CharacterCategory.DIGIT,  # '²'
    254: CharacterCategory.SYMBOL,  # '■'
    255: CharacterCategory.CONTROL,  # '\xa0'
}

CP850_NORWEGIAN_MODEL = SingleByteCharSetModel(
    charset_name="CP850",
    language="Norwegian",
    char_to_order_map=CP850_NORWEGIAN_CHAR_TO_ORDER,
    language_model=NORWEGIAN_LANG_MODEL,
    typical_positive_ratio=0.9785657009892291,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÅÆØåæø",
)

CP858_NORWEGIAN_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 27,  # 'A'
    66: 35,  # 'B'
    67: 44,  # 'C'
    68: 25,  # 'D'
    69: 30,  # 'E'
    70: 34,  # 'F'
    71: 43,  # 'G'
    72: 29,  # 'H'
    73: 36,  # 'I'
    74: 45,  # 'J'
    75: 38,  # 'K'
    76: 40,  # 'L'
    77: 32,  # 'M'
    78: 28,  # 'N'
    79: 42,  # 'O'
    80: 39,  # 'P'
    81: 57,  # 'Q'
    82: 41,  # 'R'
    83: 24,  # 'S'
    84: 33,  # 'T'
    85: 47,  # 'U'
    86: 37,  # 'V'
    87: 49,  # 'W'
    88: 54,  # 'X'
    89: 53,  # 'Y'
    90: 56,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 7,  # 'a'
    98: 19,  # 'b'
    99: 26,  # 'c'
    100: 10,  # 'd'
    101: 1,  # 'e'
    102: 16,  # 'f'
    103: 11,  # 'g'
    104: 20,  # 'h'
    105: 5,  # 'i'
    106: 21,  # 'j'
    107: 12,  # 'k'
    108: 8,  # 'l'
    109: 13,  # 'm'
    110: 4,  # 'n'
    111: 9,  # 'o'
    112: 15,  # 'p'
    113: 55,  # 'q'
    114: 2,  # 'r'
    115: 6,  # 's'
    116: 3,  # 't'
    117: 17,  # 'u'
    118: 14,  # 'v'
    119: 46,  # 'w'
    120: 48,  # 'x'
    121: 23,  # 'y'
    122: 50,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 0,  # 'Ç'
    129: 0,  # 'ü'
    130: 0,  # 'é'
    131: 0,  # 'â'
    132: 0,  # 'ä'
    133: 0,  # 'à'
    134: 18,  # 'å'
    135: 0,  # 'ç'
    136: 0,  # 'ê'
    137: 0,  # 'ë'
    138: 0,  # 'è'
    139: 0,  # 'ï'
    140: 0,  # 'î'
    141: 0,  # 'ì'
    142: 0,  # 'Ä'
    143: 51,  # 'Å'
    144: 0,  # 'É'
    145: 31,  # 'æ'
    146: 58,  # 'Æ'
    147: 0,  # 'ô'
    148: 0,  # 'ö'
    149: 0,  # 'ò'
    150: 0,  # 'û'
    151: 0,  # 'ù'
    152: 0,  # 'ÿ'
    153: 0,  # 'Ö'
    154: 0,  # 'Ü'
    155: 22,  # 'ø'
    156: CharacterCategory.SYMBOL,  # '£'
    157: 52,  # 'Ø'
    158: CharacterCategory.SYMBOL,  # '×'
    159: 0,  # 'ƒ'
    160: 0,  # 'á'
    161: 0,  # 'í'
    162: 0,  # 'ó'
    163: 0,  # 'ú'
    164: 0,  # 'ñ'
    165: 0,  # 'Ñ'
    166: 0,  # 'ª'
    167: 0,  # 'º'
    168: CharacterCategory.SYMBOL,  # '¿'
    169: CharacterCategory.SYMBOL,  # '®'
    170: CharacterCategory.SYMBOL,  # '¬'
    171: CharacterCategory.DIGIT,  # '½'
    172: CharacterCategory.DIGIT,  # '¼'
    173: CharacterCategory.SYMBOL,  # '¡'
    174: CharacterCategory.SYMBOL,  # '«'
    175: CharacterCategory.SYMBOL,  # '»'
    176: CharacterCategory.SYMBOL,  # '░'
    177: CharacterCategory.SYMBOL,  # '▒'
    178: CharacterCategory.SYMBOL,  # '▓'
    179: CharacterCategory.SYMBOL,  # '│'
    180: CharacterCategory.SYMBOL,  # '┤'
    181: 0,  # 'Á'
    182: 0,  # 'Â'
    183: 0,  # 'À'
    184: CharacterCategory.SYMBOL,  # '©'
    185: CharacterCategory.SYMBOL,  # '╣'
    186: CharacterCategory.SYMBOL,  # '║'
    187: CharacterCategory.SYMBOL,  # '╗'
    188: CharacterCategory.SYMBOL,  # '╝'
    189: CharacterCategory.SYMBOL,  # '¢'
    190: CharacterCategory.SYMBOL,  # '¥'
    191: CharacterCategory.SYMBOL,  # '┐'
    192: CharacterCategory.SYMBOL,  # '└'
    193: CharacterCategory.SYMBOL,  # '┴'
    194: CharacterCategory.SYMBOL,  # '┬'
    195: CharacterCategory.SYMBOL,  # '├'
    196: CharacterCategory.SYMBOL,  # '─'
    197: CharacterCategory.SYMBOL,  # '┼'
    198: 0,  # 'ã'
    199: 0,  # 'Ã'
    200: CharacterCategory.SYMBOL,  # '╚'
    201: CharacterCategory.SYMBOL,  # '╔'
    202: CharacterCategory.SYMBOL,  # '╩'
    203: CharacterCategory.SYMBOL,  # '╦'
    204: CharacterCategory.SYMBOL,  # '╠'
    205: CharacterCategory.SYMBOL,  # '═'
    206: CharacterCategory.SYMBOL,  # '╬'
    207: CharacterCategory.SYMBOL,  # '¤'
    208: 0,  # 'ð'
    209: 0,  # 'Ð'
    210: 0,  # 'Ê'
    211: 0,  # 'Ë'
    212: 0,  # 'È'
    213: CharacterCategory.SYMBOL,  # '€'
    214: 0,  # 'Í'
    215: 0,  # 'Î'
    216: 0,  # 'Ï'
    217: CharacterCategory.SYMBOL,  # '┘'
    218: CharacterCategory.SYMBOL,  # '┌'
    219: CharacterCategory.SYMBOL,  # '█'
    220: CharacterCategory.SYMBOL,  # '▄'
    221: CharacterCategory.SYMBOL,  # '¦'
    222: 0,  # 'Ì'
    223: CharacterCategory.SYMBOL,  # '▀'
    224: 0,  # 'Ó'
    225: 0,  # 'ß'
    226: 0,  # 'Ô'
    227: 0,  # 'Ò'
    228: 0,  # 'õ'
    229: 0,  # 'Õ'
    230: 0,  # 'µ'
    231: 0,  # 'þ'
    232: 0,  # 'Þ'
    233: 0,  # 'Ú'
    234: 0,  # 'Û'
    235: 0,  # 'Ù'
    236: 0,  # 'ý'
    237: 0,  # 'Ý'
    238: CharacterCategory.SYMBOL,  # '¯'
    239: CharacterCategory.SYMBOL,  # '´'
    240: CharacterCategory.CONTROL,  # '\xad'
    241: CharacterCategory.SYMBOL,  # '±'
    242: CharacterCategory.SYMBOL,  # '‗'
    243: CharacterCategory.DIGIT,  # '¾'
    244: CharacterCategory.SYMBOL,  # '¶'
    245: CharacterCategory.SYMBOL,  # '§'
    246: CharacterCategory.SYMBOL,  # '÷'
    247: CharacterCategory.SYMBOL,  # '¸'
    248: CharacterCategory.SYMBOL,  # '°'
    249: CharacterCategory.SYMBOL,  # '¨'
    250: CharacterCategory.SYMBOL,  # '·'
    251: CharacterCategory.DIGIT,  # '¹'
    252: CharacterCategory.DIGIT,  # '³'
    253: CharacterCategory.DIGIT,  # '²'
    254: CharacterCategory.SYMBOL,  # '■'
    255: CharacterCategory.CONTROL,  # '\xa0'
}

CP858_NORWEGIAN_MODEL = SingleByteCharSetModel(
    charset_name="CP858",
    language="Norwegian",
    char_to_order_map=CP858_NORWEGIAN_CHAR_TO_ORDER,
    language_model=NORWEGIAN_LANG_MODEL,
    typical_positive_ratio=0.9785657009892291,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÅÆØåæø",
)

CP865_NORWEGIAN_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 27,  # 'A'
    66: 35,  # 'B'
    67: 44,  # 'C'
    68: 25,  # 'D'
    69: 30,  # 'E'
    70: 34,  # 'F'
    71: 43,  # 'G'
    72: 29,  # 'H'
    73: 36,  # 'I'
    74: 45,  # 'J'
    75: 38,  # 'K'
    76: 40,  # 'L'
    77: 32,  # 'M'
    78: 28,  # 'N'
    79: 42,  # 'O'
    80: 39,  # 'P'
    81: 57,  # 'Q'
    82: 41,  # 'R'
    83: 24,  # 'S'
    84: 33,  # 'T'
    85: 47,  # 'U'
    86: 37,  # 'V'
    87: 49,  # 'W'
    88: 54,  # 'X'
    89: 53,  # 'Y'
    90: 56,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 7,  # 'a'
    98: 19,  # 'b'
    99: 26,  # 'c'
    100: 10,  # 'd'
    101: 1,  # 'e'
    102: 16,  # 'f'
    103: 11,  # 'g'
    104: 20,  # 'h'
    105: 5,  # 'i'
    106: 21,  # 'j'
    107: 12,  # 'k'
    108: 8,  # 'l'
    109: 13,  # 'm'
    110: 4,  # 'n'
    111: 9,  # 'o'
    112: 15,  # 'p'
    113: 55,  # 'q'
    114: 2,  # 'r'
    115: 6,  # 's'
    116: 3,  # 't'
    117: 17,  # 'u'
    118: 14,  # 'v'
    119: 46,  # 'w'
    120: 48,  # 'x'
    121: 23,  # 'y'
    122: 50,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 0,  # 'Ç'
    129: 0,  # 'ü'
    130: 0,  # 'é'
    131: 0,  # 'â'
    132: 0,  # 'ä'
    133: 0,  # 'à'
    134: 18,  # 'å'
    135: 0,  # 'ç'
    136: 0,  # 'ê'
    137: 0,  # 'ë'
    138: 0,  # 'è'
    139: 0,  # 'ï'
    140: 0,  # 'î'
    141: 0,  # 'ì'
    142: 0,  # 'Ä'
    143: 51,  # 'Å'
    144: 0,  # 'É'
    145: 31,  # 'æ'
    146: 58,  # 'Æ'
    147: 0,  # 'ô'
    148: 0,  # 'ö'
    149: 0,  # 'ò'
    150: 0,  # 'û'
    151: 0,  # 'ù'
    152: 0,  # 'ÿ'
    153: 0,  # 'Ö'
    154: 0,  # 'Ü'
    155: 22,  # 'ø'
    156: CharacterCategory.SYMBOL,  # '£'
    157: 52,  # 'Ø'
    158: CharacterCategory.SYMBOL,  # '₧'
    159: 0,  # 'ƒ'
    160: 0,  # 'á'
    161: 0,  # 'í'
    162: 0,  # 'ó'
    163: 0,  # 'ú'
    164: 0,  # 'ñ'
    165: 0,  # 'Ñ'
    166: 0,  # 'ª'
    167: 0,  # 'º'
    168: CharacterCategory.SYMBOL,  # '¿'
    169: CharacterCategory.SYMBOL,  # '⌐'
    170: CharacterCategory.SYMBOL,  # '¬'
    171: CharacterCategory.DIGIT,  # '½'
    172: CharacterCategory.DIGIT,  # '¼'
    173: CharacterCategory.SYMBOL,  # '¡'
    174: CharacterCategory.SYMBOL,  # '«'
    175: CharacterCategory.SYMBOL,  # '¤'
    176: CharacterCategory.SYMBOL,  # '░'
    177: CharacterCategory.SYMBOL,  # '▒'
    178: CharacterCategory.SYMBOL,  # '▓'
    179: CharacterCategory.SYMBOL,  # '│'
    180: CharacterCategory.SYMBOL,  # '┤'
    181: CharacterCategory.SYMBOL,  # '╡'
    182: CharacterCategory.SYMBOL,  # '╢'
    183: CharacterCategory.SYMBOL,  # '╖'
    184: CharacterCategory.SYMBOL,  # '╕'
    185: CharacterCategory.SYMBOL,  # '╣'
    186: CharacterCategory.SYMBOL,  # '║'
    187: CharacterCategory.SYMBOL,  # '╗'
    188: CharacterCategory.SYMBOL,  # '╝'
    189: CharacterCategory.SYMBOL,  # '╜'
    190: CharacterCategory.SYMBOL,  # '╛'
    191: CharacterCategory.SYMBOL,  # '┐'
    192: CharacterCategory.SYMBOL,  # '└'
    193: CharacterCategory.SYMBOL,  # '┴'
    194: CharacterCategory.SYMBOL,  # '┬'
    195: CharacterCategory.SYMBOL,  # '├'
    196: CharacterCategory.SYMBOL,  # '─'
    197: CharacterCategory.SYMBOL,  # '┼'
    198: CharacterCategory.SYMBOL,  # '╞'
    199: CharacterCategory.SYMBOL,  # '╟'
    200: CharacterCategory.SYMBOL,  # '╚'
    201: CharacterCategory.SYMBOL,  # '╔'
    202: CharacterCategory.SYMBOL,  # '╩'
    203: CharacterCategory.SYMBOL,  # '╦'
    204: CharacterCategory.SYMBOL,  # '╠'
    205: CharacterCategory.SYMBOL,  # '═'
    206: CharacterCategory.SYMBOL,  # '╬'
    207: CharacterCategory.SYMBOL,  # '╧'
    208: CharacterCategory.SYMBOL,  # '╨'
    209: CharacterCategory.SYMBOL,  # '╤'
    210: CharacterCategory.SYMBOL,  # '╥'
    211: CharacterCategory.SYMBOL,  # '╙'
    212: CharacterCategory.SYMBOL,  # '╘'
    213: CharacterCategory.SYMBOL,  # '╒'
    214: CharacterCategory.SYMBOL,  # '╓'
    215: CharacterCategory.SYMBOL,  # '╫'
    216: CharacterCategory.SYMBOL,  # '╪'
    217: CharacterCategory.SYMBOL,  # '┘'
    218: CharacterCategory.SYMBOL,  # '┌'
    219: CharacterCategory.SYMBOL,  # '█'
    220: CharacterCategory.SYMBOL,  # '▄'
    221: CharacterCategory.SYMBOL,  # '▌'
    222: CharacterCategory.SYMBOL,  # '▐'
    223: CharacterCategory.SYMBOL,  # '▀'
    224: 0,  # 'α'
    225: 0,  # 'ß'
    226: 0,  # 'Γ'
    227: 0,  # 'π'
    228: 0,  # 'Σ'
    229: 0,  # 'σ'
    230: 0,  # 'µ'
    231: 0,  # 'τ'
    232: 0,  # 'Φ'
    233: 0,  # 'Θ'
    234: 0,  # 'Ω'
    235: 0,  # 'δ'
    236: CharacterCategory.SYMBOL,  # '∞'
    237: 0,  # 'φ'
    238: 0,  # 'ε'
    239: CharacterCategory.SYMBOL,  # '∩'
    240: CharacterCategory.SYMBOL,  # '≡'
    241: CharacterCategory.SYMBOL,  # '±'
    242: CharacterCategory.SYMBOL,  # '≥'
    243: CharacterCategory.SYMBOL,  # '≤'
    244: CharacterCategory.SYMBOL,  # '⌠'
    245: CharacterCategory.SYMBOL,  # '⌡'
    246: CharacterCategory.SYMBOL,  # '÷'
    247: CharacterCategory.SYMBOL,  # '≈'
    248: CharacterCategory.SYMBOL,  # '°'
    249: CharacterCategory.SYMBOL,  # '∙'
    250: CharacterCategory.SYMBOL,  # '·'
    251: CharacterCategory.SYMBOL,  # '√'
    252: 0,  # 'ⁿ'
    253: CharacterCategory.DIGIT,  # '²'
    254: CharacterCategory.SYMBOL,  # '■'
    255: CharacterCategory.CONTROL,  # '\xa0'
}

CP865_NORWEGIAN_MODEL = SingleByteCharSetModel(
    charset_name="CP865",
    language="Norwegian",
    char_to_order_map=CP865_NORWEGIAN_CHAR_TO_ORDER,
    language_model=NORWEGIAN_LANG_MODEL,
    typical_positive_ratio=0.9785657009892291,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÅÆØåæø",
)

ISO_8859_1_NORWEGIAN_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 27,  # 'A'
    66: 35,  # 'B'
    67: 44,  # 'C'
    68: 25,  # 'D'
    69: 30,  # 'E'
    70: 34,  # 'F'
    71: 43,  # 'G'
    72: 29,  # 'H'
    73: 36,  # 'I'
    74: 45,  # 'J'
    75: 38,  # 'K'
    76: 40,  # 'L'
    77: 32,  # 'M'
    78: 28,  # 'N'
    79: 42,  # 'O'
    80: 39,  # 'P'
    81: 57,  # 'Q'
    82: 41,  # 'R'
    83: 24,  # 'S'
    84: 33,  # 'T'
    85: 47,  # 'U'
    86: 37,  # 'V'
    87: 49,  # 'W'
    88: 54,  # 'X'
    89: 53,  # 'Y'
    90: 56,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 7,  # 'a'
    98: 19,  # 'b'
    99: 26,  # 'c'
    100: 10,  # 'd'
    101: 1,  # 'e'
    102: 16,  # 'f'
    103: 11,  # 'g'
    104: 20,  # 'h'
    105: 5,  # 'i'
    106: 21,  # 'j'
    107: 12,  # 'k'
    108: 8,  # 'l'
    109: 13,  # 'm'
    110: 4,  # 'n'
    111: 9,  # 'o'
    112: 15,  # 'p'
    113: 55,  # 'q'
    114: 2,  # 'r'
    115: 6,  # 's'
    116: 3,  # 't'
    117: 17,  # 'u'
    118: 14,  # 'v'
    119: 46,  # 'w'
    120: 48,  # 'x'
    121: 23,  # 'y'
    122: 50,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.CONTROL,  # '\x80'
    129: CharacterCategory.CONTROL,  # '\x81'
    130: CharacterCategory.CONTROL,  # '\x82'
    131: CharacterCategory.CONTROL,  # '\x83'
    132: CharacterCategory.CONTROL,  # '\x84'
    133: CharacterCategory.CONTROL,  # '\x85'
    134: CharacterCategory.CONTROL,  # '\x86'
    135: CharacterCategory.CONTROL,  # '\x87'
    136: CharacterCategory.CONTROL,  # '\x88'
    137: CharacterCategory.CONTROL,  # '\x89'
    138: CharacterCategory.CONTROL,  # '\x8a'
    139: CharacterCategory.CONTROL,  # '\x8b'
    140: CharacterCategory.CONTROL,  # '\x8c'
    141: CharacterCategory.CONTROL,  # '\x8d'
    142: CharacterCategory.CONTROL,  # '\x8e'
    143: CharacterCategory.CONTROL,  # '\x8f'
    144: CharacterCategory.CONTROL,  # '\x90'
    145: CharacterCategory.CONTROL,  # '\x91'
    146: CharacterCategory.CONTROL,  # '\x92'
    147: CharacterCategory.CONTROL,  # '\x93'
    148: CharacterCategory.CONTROL,  # '\x94'
    149: CharacterCategory.CONTROL,  # '\x95'
    150: CharacterCategory.CONTROL,  # '\x96'
    151: CharacterCategory.CONTROL,  # '\x97'
    152: CharacterCategory.CONTROL,  # '\x98'
    153: CharacterCategory.CONTROL,  # '\x99'
    154: CharacterCategory.CONTROL,  # '\x9a'
    155: CharacterCategory.CONTROL,  # '\x9b'
    156: CharacterCategory.CONTROL,  # '\x9c'
    157: CharacterCategory.CONTROL,  # '\x9d'
    158: CharacterCategory.CONTROL,  # '\x9e'
    159: CharacterCategory.CONTROL,  # '\x9f'
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: CharacterCategory.SYMBOL,  # '¡'
    162: CharacterCategory.SYMBOL,  # '¢'
    163: CharacterCategory.SYMBOL,  # '£'
    164: CharacterCategory.SYMBOL,  # '¤'
    165: CharacterCategory.SYMBOL,  # '¥'
    166: CharacterCategory.SYMBOL,  # '¦'
    167: CharacterCategory.SYMBOL,  # '§'
    168: CharacterCategory.SYMBOL,  # '¨'
    169: CharacterCategory.SYMBOL,  # '©'
    170: 0,  # 'ª'
    171: CharacterCategory.SYMBOL,  # '«'
    172: CharacterCategory.SYMBOL,  # '¬'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: CharacterCategory.SYMBOL,  # '®'
    175: CharacterCategory.SYMBOL,  # '¯'
    176: CharacterCategory.SYMBOL,  # '°'
    177: CharacterCategory.SYMBOL,  # '±'
    178: CharacterCategory.DIGIT,  # '²'
    179: CharacterCategory.DIGIT,  # '³'
    180: CharacterCategory.SYMBOL,  # '´'
    181: 0,  # 'µ'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.SYMBOL,  # '·'
    184: CharacterCategory.SYMBOL,  # '¸'
    185: CharacterCategory.DIGIT,  # '¹'
    186: 0,  # 'º'
    187: CharacterCategory.SYMBOL,  # '»'
    188: CharacterCategory.DIGIT,  # '¼'
    189: CharacterCategory.DIGIT,  # '½'
    190: CharacterCategory.DIGIT,  # '¾'
    191: CharacterCategory.SYMBOL,  # '¿'
    192: 0,  # 'À'
    193: 0,  # 'Á'
    194: 0,  # 'Â'
    195: 0,  # 'Ã'
    196: 0,  # 'Ä'
    197: 51,  # 'Å'
    198: 58,  # 'Æ'
    199: 0,  # 'Ç'
    200: 0,  # 'È'
    201: 0,  # 'É'
    202: 0,  # 'Ê'
    203: 0,  # 'Ë'
    204: 0,  # 'Ì'
    205: 0,  # 'Í'
    206: 0,  # 'Î'
    207: 0,  # 'Ï'
    208: 0,  # 'Ð'
    209: 0,  # 'Ñ'
    210: 0,  # 'Ò'
    211: 0,  # 'Ó'
    212: 0,  # 'Ô'
    213: 0,  # 'Õ'
    214: 0,  # 'Ö'
    215: CharacterCategory.SYMBOL,  # '×'
    216: 52,  # 'Ø'
    217: 0,  # 'Ù'
    218: 0,  # 'Ú'
    219: 0,  # 'Û'
    220: 0,  # 'Ü'
    221: 0,  # 'Ý'
    222: 0,  # 'Þ'
    223: 0,  # 'ß'
    224: 0,  # 'à'
    225: 0,  # 'á'
    226: 0,  # 'â'
    227: 0,  # 'ã'
    228: 0,  # 'ä'
    229: 18,  # 'å'
    230: 31,  # 'æ'
    231: 0,  # 'ç'
    232: 0,  # 'è'
    233: 0,  # 'é'
    234: 0,  # 'ê'
    235: 0,  # 'ë'
    236: 0,  # 'ì'
    237: 0,  # 'í'
    238: 0,  # 'î'
    239: 0,  # 'ï'
    240: 0,  # 'ð'
    241: 0,  # 'ñ'
    242: 0,  # 'ò'
    243: 0,  # 'ó'
    244: 0,  # 'ô'
    245: 0,  # 'õ'
    246: 0,  # 'ö'
    247: CharacterCategory.SYMBOL,  # '÷'
    248: 22,  # 'ø'
    249: 0,  # 'ù'
    250: 0,  # 'ú'
    251: 0,  # 'û'
    252: 0,  # 'ü'
    253: 0,  # 'ý'
    254: 0,  # 'þ'
    255: 0,  # 'ÿ'
}

ISO_8859_1_NORWEGIAN_MODEL = SingleByteCharSetModel(
    charset_name="ISO-8859-1",
    language="Norwegian",
    char_to_order_map=ISO_8859_1_NORWEGIAN_CHAR_TO_ORDER,
    language_model=NORWEGIAN_LANG_MODEL,
    typical_positive_ratio=0.9785657009892291,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÅÆØåæø",
)

ISO_8859_15_NORWEGIAN_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 27,  # 'A'
    66: 35,  # 'B'
    67: 44,  # 'C'
    68: 25,  # 'D'
    69: 30,  # 'E'
    70: 34,  # 'F'
    71: 43,  # 'G'
    72: 29,  # 'H'
    73: 36,  # 'I'
    74: 45,  # 'J'
    75: 38,  # 'K'
    76: 40,  # 'L'
    77: 32,  # 'M'
    78: 28,  # 'N'
    79: 42,  # 'O'
    80: 39,  # 'P'
    81: 57,  # 'Q'
    82: 41,  # 'R'
    83: 24,  # 'S'
    84: 33,  # 'T'
    85: 47,  # 'U'
    86: 37,  # 'V'
    87: 49,  # 'W'
    88: 54,  # 'X'
    89: 53,  # 'Y'
    90: 56,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 7,  # 'a'
    98: 19,  # 'b'
    99: 26,  # 'c'
    100: 10,  # 'd'
    101: 1,  # 'e'
    102: 16,  # 'f'
    103: 11,  # 'g'
    104: 20,  # 'h'
    105: 5,  # 'i'
    106: 21,  # 'j'
    107: 12,  # 'k'
    108: 8,  # 'l'
    109: 13,  # 'm'
    110: 4,  # 'n'
    111: 9,  # 'o'
    112: 15,  # 'p'
    113: 55,  # 'q'
    114: 2,  # 'r'
    115: 6,  # 's'
    116: 3,  # 't'
    117: 17,  # 'u'
    118: 14,  # 'v'
    119: 46,  # 'w'
    120: 48,  # 'x'
    121: 23,  # 'y'
    122: 50,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.CONTROL,  # '\x80'
    129: CharacterCategory.CONTROL,  # '\x81'
    130: CharacterCategory.CONTROL,  # '\x82'
    131: CharacterCategory.CONTROL,  # '\x83'
    132: CharacterCategory.CONTROL,  # '\x84'
    133: CharacterCategory.CONTROL,  # '\x85'
    134: CharacterCategory.CONTROL,  # '\x86'
    135: CharacterCategory.CONTROL,  # '\x87'
    136: CharacterCategory.CONTROL,  # '\x88'
    137: CharacterCategory.CONTROL,  # '\x89'
    138: CharacterCategory.CONTROL,  # '\x8a'
    139: CharacterCategory.CONTROL,  # '\x8b'
    140: CharacterCategory.CONTROL,  # '\x8c'
    141: CharacterCategory.CONTROL,  # '\x8d'
    142: CharacterCategory.CONTROL,  # '\x8e'
    143: CharacterCategory.CONTROL,  # '\x8f'
    144: CharacterCategory.CONTROL,  # '\x90'
    145: CharacterCategory.CONTROL,  # '\x91'
    146: CharacterCategory.CONTROL,  # '\x92'
    147: CharacterCategory.CONTROL,  # '\x93'
    148: CharacterCategory.CONTROL,  # '\x94'
    149: CharacterCategory.CONTROL,  # '\x95'
    150: CharacterCategory.CONTROL,  # '\x96'
    151: CharacterCategory.CONTROL,  # '\x97'
    152: CharacterCategory.CONTROL,  # '\x98'
    153: CharacterCategory.CONTROL,  # '\x99'
    154: CharacterCategory.CONTROL,  # '\x9a'
    155: CharacterCategory.CONTROL,  # '\x9b'
    156: CharacterCategory.CONTROL,  # '\x9c'
    157: CharacterCategory.CONTROL,  # '\x9d'
    158: CharacterCategory.CONTROL,  # '\x9e'
    159: CharacterCategory.CONTROL,  # '\x9f'
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: CharacterCategory.SYMBOL,  # '¡'
    162: CharacterCategory.SYMBOL,  # '¢'
    163: CharacterCategory.SYMBOL,  # '£'
    164: CharacterCategory.SYMBOL,  # '€'
    165: CharacterCategory.SYMBOL,  # '¥'
    166: 0,  # 'Š'
    167: CharacterCategory.SYMBOL,  # '§'
    168: 0,  # 'š'
    169: CharacterCategory.SYMBOL,  # '©'
    170: 0,  # 'ª'
    171: CharacterCategory.SYMBOL,  # '«'
    172: CharacterCategory.SYMBOL,  # '¬'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: CharacterCategory.SYMBOL,  # '®'
    175: CharacterCategory.SYMBOL,  # '¯'
    176: CharacterCategory.SYMBOL,  # '°'
    177: CharacterCategory.SYMBOL,  # '±'
    178: CharacterCategory.DIGIT,  # '²'
    179: CharacterCategory.DIGIT,  # '³'
    180: 0,  # 'Ž'
    181: 0,  # 'µ'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.SYMBOL,  # '·'
    184: 0,  # 'ž'
    185: CharacterCategory.DIGIT,  # '¹'
    186: 0,  # 'º'
    187: CharacterCategory.SYMBOL,  # '»'
    188: 0,  # 'Œ'
    189: 0,  # 'œ'
    190: 0,  # 'Ÿ'
    191: CharacterCategory.SYMBOL,  # '¿'
    192: 0,  # 'À'
    193: 0,  # 'Á'
    194: 0,  # 'Â'
    195: 0,  # 'Ã'
    196: 0,  # 'Ä'
    197: 51,  # 'Å'
    198: 58,  # 'Æ'
    199: 0,  # 'Ç'
    200: 0,  # 'È'
    201: 0,  # 'É'
    202: 0,  # 'Ê'
    203: 0,  # 'Ë'
    204: 0,  # 'Ì'
    205: 0,  # 'Í'
    206: 0,  # 'Î'
    207: 0,  # 'Ï'
    208: 0,  # 'Ð'
    209: 0,  # 'Ñ'
    210: 0,  # 'Ò'
    211: 0,  # 'Ó'
    212: 0,  # 'Ô'
    213: 0,  # 'Õ'
    214: 0,  # 'Ö'
    215: CharacterCategory.SYMBOL,  # '×'
    216: 52,  # 'Ø'
    217: 0,  # 'Ù'
    218: 0,  # 'Ú'
    219: 0,  # 'Û'
    220: 0,  # 'Ü'
    221: 0,  # 'Ý'
    222: 0,  # 'Þ'
    223: 0,  # 'ß'
    224: 0,  # 'à'
    225: 0,  # 'á'
    226: 0,  # 'â'
    227: 0,  # 'ã'
    228: 0,  # 'ä'
    229: 18,  # 'å'
    230: 31,  # 'æ'
    231: 0,  # 'ç'
    232: 0,  # 'è'
    233: 0,  # 'é'
    234: 0,  # 'ê'
    235: 0,  # 'ë'
    236: 0,  # 'ì'
    237: 0,  # 'í'
    238: 0,  # 'î'
    239: 0,  # 'ï'
    240: 0,  # 'ð'
    241: 0,  # 'ñ'
    242: 0,  # 'ò'
    243: 0,  # 'ó'
    244: 0,  # 'ô'
    245: 0,  # 'õ'
    246: 0,  # 'ö'
    247: CharacterCategory.SYMBOL,  # '÷'
    248: 22,  # 'ø'
    249: 0,  # 'ù'
    250: 0,  # 'ú'
    251: 0,  # 'û'
    252: 0,  # 'ü'
    253: 0,  # 'ý'
    254: 0,  # 'þ'
    255: 0,  # 'ÿ'
}

ISO_8859_15_NORWEGIAN_MODEL = SingleByteCharSetModel(
    charset_name="ISO-8859-15",
    language="Norwegian",
    char_to_order_map=ISO_8859_15_NORWEGIAN_CHAR_TO_ORDER,
    language_model=NORWEGIAN_LANG_MODEL,
    typical_positive_ratio=0.9785657009892291,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÅÆØåæø",
)

MACROMAN_NORWEGIAN_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 27,  # 'A'
    66: 35,  # 'B'
    67: 44,  # 'C'
    68: 25,  # 'D'
    69: 30,  # 'E'
    70: 34,  # 'F'
    71: 43,  # 'G'
    72: 29,  # 'H'
    73: 36,  # 'I'
    74: 45,  # 'J'
    75: 38,  # 'K'
    76: 40,  # 'L'
    77: 32,  # 'M'
    78: 28,  # 'N'
    79: 42,  # 'O'
    80: 39,  # 'P'
    81: 57,  # 'Q'
    82: 41,  # 'R'
    83: 24,  # 'S'
    84: 33,  # 'T'
    85: 47,  # 'U'
    86: 37,  # 'V'
    87: 49,  # 'W'
    88: 54,  # 'X'
    89: 53,  # 'Y'
    90: 56,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 7,  # 'a'
    98: 19,  # 'b'
    99: 26,  # 'c'
    100: 10,  # 'd'
    101: 1,  # 'e'
    102: 16,  # 'f'
    103: 11,  # 'g'
    104: 20,  # 'h'
    105: 5,  # 'i'
    106: 21,  # 'j'
    107: 12,  # 'k'
    108: 8,  # 'l'
    109: 13,  # 'm'
    110: 4,  # 'n'
    111: 9,  # 'o'
    112: 15,  # 'p'
    113: 55,  # 'q'
    114: 2,  # 'r'
    115: 6,  # 's'
    116: 3,  # 't'
    117: 17,  # 'u'
    118: 14,  # 'v'
    119: 46,  # 'w'
    120: 48,  # 'x'
    121: 23,  # 'y'
    122: 50,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 0,  # 'Ä'
    129: 51,  # 'Å'
    130: 0,  # 'Ç'
    131: 0,  # 'É'
    132: 0,  # 'Ñ'
    133: 0,  # 'Ö'
    134: 0,  # 'Ü'
    135: 0,  # 'á'
    136: 0,  # 'à'
    137: 0,  # 'â'
    138: 0,  # 'ä'
    139: 0,  # 'ã'
    140: 18,  # 'å'
    141: 0,  # 'ç'
    142: 0,  # 'é'
    143: 0,  # 'è'
    144: 0,  # 'ê'
    145: 0,  # 'ë'
    146: 0,  # 'í'
    147: 0,  # 'ì'
    148: 0,  # 'î'
    149: 0,  # 'ï'
    150: 0,  # 'ñ'
    151: 0,  # 'ó'
    152: 0,  # 'ò'
    153: 0,  # 'ô'
    154: 0,  # 'ö'
    155: 0,  # 'õ'
    156: 0,  # 'ú'
    157: 0,  # 'ù'
    158: 0,  # 'û'
    159: 0,  # 'ü'
    160: CharacterCategory.SYMBOL,  # '†'
    161: CharacterCategory.SYMBOL,  # '°'
    162: CharacterCategory.SYMBOL,  # '¢'
    163: CharacterCategory.SYMBOL,  # '£'
    164: CharacterCategory.SYMBOL,  # '§'
    165: CharacterCategory.SYMBOL,  # '•'
    166: CharacterCategory.SYMBOL,  # '¶'
    167: 0,  # 'ß'
    168: CharacterCategory.SYMBOL,  # '®'
    169: CharacterCategory.SYMBOL,  # '©'
    170: CharacterCategory.SYMBOL,  # '™'
    171: CharacterCategory.SYMBOL,  # '´'
    172: CharacterCategory.SYMBOL,  # '¨'
    173: CharacterCategory.SYMBOL,  # '≠'
    174: 58,  # 'Æ'
    175: 52,  # 'Ø'
    176: CharacterCategory.SYMBOL,  # '∞'
    177: CharacterCategory.SYMBOL,  # '±'
    178: CharacterCategory.SYMBOL,  # '≤'
    179: CharacterCategory.SYMBOL,  # '≥'
    180: CharacterCategory.SYMBOL,  # '¥'
    181: 0,  # 'µ'
    182: CharacterCategory.SYMBOL,  # '∂'
    183: CharacterCategory.SYMBOL,  # '∑'
    184: CharacterCategory.SYMBOL,  # '∏'
    185: 0,  # 'π'
    186: CharacterCategory.SYMBOL,  # '∫'
    187: 0,  # 'ª'
    188: 0,  # 'º'
    189: 0,  # 'Ω'
    190: 31,  # 'æ'
    191: 22,  # 'ø'
    192: CharacterCategory.SYMBOL,  # '¿'
    193: CharacterCategory.SYMBOL,  # '¡'
    194: CharacterCategory.SYMBOL,  # '¬'
    195: CharacterCategory.SYMBOL,  # '√'
    196: 0,  # 'ƒ'
    197: CharacterCategory.SYMBOL,  # '≈'
    198: CharacterCategory.SYMBOL,  # '∆'
    199: CharacterCategory.SYMBOL,  # '«'
    200: CharacterCategory.SYMBOL,  # '»'
    201: CharacterCategory.SYMBOL,  # '…'
    202: CharacterCategory.CONTROL,  # '\xa0'
    203: 0,  # 'À'
    204: 0,  # 'Ã'
    205: 0,  # 'Õ'
    206: 0,  # 'Œ'
    207: 0,  # 'œ'
    208: CharacterCategory.SYMBOL,  # '–'
    209: CharacterCategory.SYMBOL,  # '—'
    210: CharacterCategory.SYMBOL,  # '“'
    211: CharacterCategory.SYMBOL,  # '”'
    212: CharacterCategory.SYMBOL,  # '‘'
    213: CharacterCategory.SYMBOL,  # '’'
    214: CharacterCategory.SYMBOL,  # '÷'
    215: CharacterCategory.SYMBOL,  # '◊'
    216: 0,  # 'ÿ'
    217: 0,  # 'Ÿ'
    218: CharacterCategory.SYMBOL,  # '⁄'
    219: CharacterCategory.SYMBOL,  # '€'
    220: CharacterCategory.SYMBOL,  # '‹'
    221: CharacterCategory.SYMBOL,  # '›'
    222: 0,  # 'ﬁ'
    223: 0,  # 'ﬂ'
    224: CharacterCategory.SYMBOL,  # '‡'
    225: CharacterCategory.SYMBOL,  # '·'
    226: CharacterCategory.SYMBOL,  # '‚'
    227: CharacterCategory.SYMBOL,  # '„'
    228: CharacterCategory.SYMBOL,  # '‰'
    229: 0,  # 'Â'
    230: 0,  # 'Ê'
    231: 0,  # 'Á'
    232: 0,  # 'Ë'
    233: 0,  # 'È'
    234: 0,  # 'Í'
    235: 0,  # 'Î'
    236: 0,  # 'Ï'
    237: 0,  # 'Ì'
    238: 0,  # 'Ó'
    239: 0,  # 'Ô'
    240: CharacterCategory.CONTROL,  # '\uf8ff'
    241: 0,  # 'Ò'
    242: 0,  # 'Ú'
    243: 0,  # 'Û'
    244: 0,  # 'Ù'
    245: 0,  # 'ı'
    246: 0,  # 'ˆ'
    247: CharacterCategory.SYMBOL,  # '˜'
    248: CharacterCategory.SYMBOL,  # '¯'
    249: CharacterCategory.SYMBOL,  # '˘'
    250: CharacterCategory.SYMBOL,  # '˙'
    251: CharacterCategory.SYMBOL,  # '˚'
    252: CharacterCategory.SYMBOL,  # '¸'
    253: CharacterCategory.SYMBOL,  # '˝'
    254: CharacterCategory.SYMBOL,  # '˛'
    255: 0,  # 'ˇ'
}

MACROMAN_NORWEGIAN_MODEL = SingleByteCharSetModel(
    charset_name="MacRoman",
    language="Norwegian",
    char_to_order_map=MACROMAN_NORWEGIAN_CHAR_TO_ORDER,
    language_model=NORWEGIAN_LANG_MODEL,
    typical_positive_ratio=0.9785657009892291,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÅÆØåæø",
)

WINDOWS_1252_NORWEGIAN_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 27,  # 'A'
    66: 35,  # 'B'
    67: 44,  # 'C'
    68: 25,  # 'D'
    69: 30,  # 'E'
    70: 34,  # 'F'
    71: 43,  # 'G'
    72: 29,  # 'H'
    73: 36,  # 'I'
    74: 45,  # 'J'
    75: 38,  # 'K'
    76: 40,  # 'L'
    77: 32,  # 'M'
    78: 28,  # 'N'
    79: 42,  # 'O'
    80: 39,  # 'P'
    81: 57,  # 'Q'
    82: 41,  # 'R'
    83: 24,  # 'S'
    84: 33,  # 'T'
    85: 47,  # 'U'
    86: 37,  # 'V'
    87: 49,  # 'W'
    88: 54,  # 'X'
    89: 53,  # 'Y'
    90: 56,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 7,  # 'a'
    98: 19,  # 'b'
    99: 26,  # 'c'
    100: 10,  # 'd'
    101: 1,  # 'e'
    102: 16,  # 'f'
    103: 11,  # 'g'
    104: 20,  # 'h'
    105: 5,  # 'i'
    106: 21,  # 'j'
    107: 12,  # 'k'
    108: 8,  # 'l'
    109: 13,  # 'm'
    110: 4,  # 'n'
    111: 9,  # 'o'
    112: 15,  # 'p'
    113: 55,  # 'q'
    114: 2,  # 'r'
    115: 6,  # 's'
    116: 3,  # 't'
    117: 17,  # 'u'
    118: 14,  # 'v'
    119: 46,  # 'w'
    120: 48,  # 'x'
    121: 23,  # 'y'
    122: 50,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.SYMBOL,  # '€'
    129: CharacterCategory.UNDEFINED,  # None
    130: CharacterCategory.SYMBOL,  # '‚'
    131: 0,  # 'ƒ'
    132: CharacterCategory.SYMBOL,  # '„'
    133: CharacterCategory.SYMBOL,  # '…'
    134: CharacterCategory.SYMBOL,  # '†'
    135: CharacterCategory.SYMBOL,  # '‡'
    136: 0,  # 'ˆ'
    137: CharacterCategory.SYMBOL,  # '‰'
    138: 0,  # 'Š'
    139: CharacterCategory.SYMBOL,  # '‹'
    140: 0,  # 'Œ'
    141: CharacterCategory.UNDEFINED,  # None
    142: 0,  # 'Ž'
    143: CharacterCategory.UNDEFINED,  # None
    144: CharacterCategory.UNDEFINED,  # None
    145: CharacterCategory.SYMBOL,  # '‘'
    146: CharacterCategory.SYMBOL,  # '’'
    147: CharacterCategory.SYMBOL,  # '“'
    148: CharacterCategory.SYMBOL,  # '”'
    149: CharacterCategory.SYMBOL,  # '•'
    150: CharacterCategory.SYMBOL,  # '–'
    151: CharacterCategory.SYMBOL,  # '—'
    152: CharacterCategory.SYMBOL,  # '˜'
    153: CharacterCategory.SYMBOL,  # '™'
    154: 0,  # 'š'
    155: CharacterCategory.SYMBOL,  # '›'
    156: 0,  # 'œ'
    157: CharacterCategory.UNDEFINED,  # None
    158: 0,  # 'ž'
    159: 0,  # 'Ÿ'
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: CharacterCategory.SYMBOL,  # '¡'
    162: CharacterCategory.SYMBOL,  # '¢'
    163: CharacterCategory.SYMBOL,  # '£'
    164: CharacterCategory.SYMBOL,  # '¤'
    165: CharacterCategory.SYMBOL,  # '¥'
    166: CharacterCategory.SYMBOL,  # '¦'
    167: CharacterCategory.SYMBOL,  # '§'
    168: CharacterCategory.SYMBOL,  # '¨'
    169: CharacterCategory.SYMBOL,  # '©'
    170: 0,  # 'ª'
    171: CharacterCategory.SYMBOL,  # '«'
    172: CharacterCategory.SYMBOL,  # '¬'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: CharacterCategory.SYMBOL,  # '®'
    175: CharacterCategory.SYMBOL,  # '¯'
    176: CharacterCategory.SYMBOL,  # '°'
    177: CharacterCategory.SYMBOL,  # '±'
    178: CharacterCategory.DIGIT,  # '²'
    179: CharacterCategory.DIGIT,  # '³'
    180: CharacterCategory.SYMBOL,  # '´'
    181: 0,  # 'µ'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.SYMBOL,  # '·'
    184: CharacterCategory.SYMBOL,  # '¸'
    185: CharacterCategory.DIGIT,  # '¹'
    186: 0,  # 'º'
    187: CharacterCategory.SYMBOL,  # '»'
    188: CharacterCategory.DIGIT,  # '¼'
    189: CharacterCategory.DIGIT,  # '½'
    190: CharacterCategory.DIGIT,  # '¾'
    191: CharacterCategory.SYMBOL,  # '¿'
    192: 0,  # 'À'
    193: 0,  # 'Á'
    194: 0,  # 'Â'
    195: 0,  # 'Ã'
    196: 0,  # 'Ä'
    197: 51,  # 'Å'
    198: 58,  # 'Æ'
    199: 0,  # 'Ç'
    200: 0,  # 'È'
    201: 0,  # 'É'
    202: 0,  # 'Ê'
    203: 0,  # 'Ë'
    204: 0,  # 'Ì'
    205: 0,  # 'Í'
    206: 0,  # 'Î'
    207: 0,  # 'Ï'
    208: 0,  # 'Ð'
    209: 0,  # 'Ñ'
    210: 0,  # 'Ò'
    211: 0,  # 'Ó'
    212: 0,  # 'Ô'
    213: 0,  # 'Õ'
    214: 0,  # 'Ö'
    215: CharacterCategory.SYMBOL,  # '×'
    216: 52,  # 'Ø'
    217: 0,  # 'Ù'
    218: 0,  # 'Ú'
    219: 0,  # 'Û'
    220: 0,  # 'Ü'
    221: 0,  # 'Ý'
    222: 0,  # 'Þ'
    223: 0,  # 'ß'
    224: 0,  # 'à'
    225: 0,  # 'á'
    226: 0,  # 'â'
    227: 0,  # 'ã'
    228: 0,  # 'ä'
    229: 18,  # 'å'
    230: 31,  # 'æ'
    231: 0,  # 'ç'
    232: 0,  # 'è'
    233: 0,  # 'é'
    234: 0,  # 'ê'
    235: 0,  # 'ë'
    236: 0,  # 'ì'
    237: 0,  # 'í'
    238: 0,  # 'î'
    239: 0,  # 'ï'
    240: 0,  # 'ð'
    241: 0,  # 'ñ'
    242: 0,  # 'ò'
    243: 0,  # 'ó'
    244: 0,  # 'ô'
    245: 0,  # 'õ'
    246: 0,  # 'ö'
    247: CharacterCategory.SYMBOL,  # '÷'
    248: 22,  # 'ø'
    249: 0,  # 'ù'
    250: 0,  # 'ú'
    251: 0,  # 'û'
    252: 0,  # 'ü'
    253: 0,  # 'ý'
    254: 0,  # 'þ'
    255: 0,  # 'ÿ'
}

WINDOWS_1252_NORWEGIAN_MODEL = SingleByteCharSetModel(
    charset_name="WINDOWS-1252",
    language="Norwegian",
    char_to_order_map=WINDOWS_1252_NORWEGIAN_CHAR_TO_ORDER,
    language_model=NORWEGIAN_LANG_MODEL,
    typical_positive_ratio=0.9785657009892291,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÅÆØåæø",
)
