/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.dialect;

import org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.calcite.config.NullCollation;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rel.type.RelDataTypeSystemImpl;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.fun.SqlLibraryOperators;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;

public class DuckDBSqlDialect
extends SqlDialect {
    public static final RelDataTypeSystem TYPE_SYSTEM = new RelDataTypeSystemImpl(){

        @Override
        public int getMaxPrecision(SqlTypeName typeName) {
            switch (typeName) {
                case DECIMAL: {
                    return 38;
                }
            }
            return super.getMaxPrecision(typeName);
        }

        @Override
        public int getMaxScale(SqlTypeName typeName) {
            switch (typeName) {
                case DECIMAL: {
                    return 38;
                }
            }
            return super.getMaxScale(typeName);
        }

        @Override
        public int getMaxNumericScale() {
            return this.getMaxScale(SqlTypeName.DECIMAL);
        }
    };
    public static final SqlDialect.Context DEFAULT_CONTEXT = SqlDialect.EMPTY_CONTEXT.withDatabaseProduct(SqlDialect.DatabaseProduct.DUCKDB).withIdentifierQuoteString("\"").withNullCollation(NullCollation.LAST).withDataTypeSystem(TYPE_SYSTEM);
    public static final SqlDialect DEFAULT = new DuckDBSqlDialect(DEFAULT_CONTEXT);

    public DuckDBSqlDialect(SqlDialect.Context context) {
        super(context);
    }

    @Override
    public boolean supportsApproxCountDistinct() {
        return true;
    }

    @Override
    public boolean supportsAliasedValues() {
        return false;
    }

    @Override
    public void unparseCall(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        switch (call.getKind()) {
            case MAP_VALUE_CONSTRUCTOR: {
                writer.keyword(call.getOperator().getName());
                SqlWriter.Frame mapFrame = writer.startList("{", "}");
                for (int i = 0; i < call.operandCount(); ++i) {
                    String sep = i % 2 == 0 ? "," : ":";
                    writer.sep(sep);
                    ((SqlNode)call.operand(i)).unparse(writer, leftPrec, rightPrec);
                }
                writer.endList(mapFrame);
                break;
            }
            case FLOOR: {
                if (call.operandCount() != 2) {
                    super.unparseCall(writer, call, leftPrec, rightPrec);
                    return;
                }
                DuckDBSqlDialect.unparseFloor(writer, call);
                break;
            }
            case CHAR_LENGTH: {
                SqlCall lengthCall = SqlLibraryOperators.LENGTH.createCall(SqlParserPos.ZERO, call.getOperandList());
                super.unparseCall(writer, lengthCall, leftPrec, rightPrec);
                break;
            }
            default: {
                super.unparseCall(writer, call, leftPrec, rightPrec);
            }
        }
    }

    private static void unparseFloor(SqlWriter writer, SqlCall call) {
        String format;
        SqlLiteral node = (SqlLiteral)call.operand(1);
        TimeUnitRange unit = node.getValueAs(TimeUnitRange.class);
        switch (unit) {
            case YEAR: {
                format = "year";
                break;
            }
            case MONTH: {
                format = "month";
                break;
            }
            case WEEK: {
                format = "week";
                break;
            }
            case DAY: {
                format = "day";
                break;
            }
            case HOUR: {
                format = "hour";
                break;
            }
            case MINUTE: {
                format = "minute";
                break;
            }
            case SECOND: {
                format = "second";
                break;
            }
            case MILLISECOND: {
                format = "milliseconds";
                break;
            }
            case MICROSECOND: {
                format = "microseconds";
                break;
            }
            default: {
                throw new AssertionError((Object)("DUCKDB does not support FLOOR for time unit: " + unit));
            }
        }
        writer.print("DATETRUNC");
        SqlWriter.Frame frame = writer.startList("(", ")");
        writer.print("'" + format + "'");
        writer.sep(",", true);
        ((SqlNode)call.operand(0)).unparse(writer, 0, 0);
        writer.endList(frame);
    }
}

