/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import java.util.Objects;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlTypeNameSpec;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.util.Litmus;
import org.apache.calcite.util.Util;

public class SqlCollectionTypeNameSpec
extends SqlTypeNameSpec {
    private final SqlTypeNameSpec elementTypeName;
    private final boolean elementTypeNullable;
    private final SqlTypeName collectionTypeName;

    public SqlCollectionTypeNameSpec(SqlTypeNameSpec elementTypeName, boolean elementTypeNullable, SqlTypeName collectionTypeName, SqlParserPos pos) {
        super(new SqlIdentifier(collectionTypeName.name(), pos), pos);
        this.elementTypeName = Objects.requireNonNull(elementTypeName, "elementTypeName");
        this.elementTypeNullable = elementTypeNullable;
        this.collectionTypeName = Objects.requireNonNull(collectionTypeName, "collectionTypeName");
    }

    public SqlCollectionTypeNameSpec(SqlTypeNameSpec elementTypeName, SqlTypeName collectionTypeName, SqlParserPos pos) {
        this(elementTypeName, true, collectionTypeName, pos);
    }

    public SqlTypeNameSpec getElementTypeName() {
        return this.elementTypeName;
    }

    @Override
    public RelDataType deriveType(SqlValidator validator) {
        RelDataType type = this.elementTypeName.deriveType(validator);
        if (this.elementTypeNullable) {
            type = validator.getTypeFactory().enforceTypeWithNullability(type, true);
        }
        return this.createCollectionType(type, validator.getTypeFactory());
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        this.elementTypeName.unparse(writer, leftPrec, rightPrec);
        writer.keyword(this.collectionTypeName.name());
    }

    @Override
    public boolean equalsDeep(SqlTypeNameSpec spec, Litmus litmus) {
        if (!(spec instanceof SqlCollectionTypeNameSpec)) {
            return litmus.fail("{} != {}", this, spec);
        }
        SqlCollectionTypeNameSpec that = (SqlCollectionTypeNameSpec)spec;
        if (!this.elementTypeName.equalsDeep(that.elementTypeName, litmus)) {
            return litmus.fail("{} != {}", this, spec);
        }
        if (!Objects.equals((Object)this.collectionTypeName, (Object)that.collectionTypeName)) {
            return litmus.fail("{} != {}", this, spec);
        }
        return litmus.succeed();
    }

    private RelDataType createCollectionType(RelDataType elementType, RelDataTypeFactory typeFactory) {
        switch (this.collectionTypeName) {
            case MULTISET: {
                return typeFactory.createMultisetType(elementType, -1L);
            }
            case ARRAY: {
                return typeFactory.createArrayType(elementType, -1L);
            }
        }
        throw Util.unexpected(this.collectionTypeName);
    }
}

