/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.datasources.transport;

import org.opensearch.action.ActionType;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.sql.common.setting.Settings;
import org.opensearch.sql.datasource.DataSourceService;
import org.opensearch.sql.datasource.model.DataSourceMetadata;
import org.opensearch.sql.datasources.model.transport.CreateDataSourceActionRequest;
import org.opensearch.sql.datasources.model.transport.CreateDataSourceActionResponse;
import org.opensearch.sql.datasources.service.DataSourceServiceImpl;
import org.opensearch.sql.opensearch.setting.OpenSearchSettings;
import org.opensearch.sql.protocol.response.format.JsonResponseFormatter;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class TransportCreateDataSourceAction
extends HandledTransportAction<CreateDataSourceActionRequest, CreateDataSourceActionResponse> {
    public static final String NAME = "cluster:admin/opensearch/ql/datasources/create";
    public static final ActionType<CreateDataSourceActionResponse> ACTION_TYPE = new ActionType("cluster:admin/opensearch/ql/datasources/create", CreateDataSourceActionResponse::new);
    private final DataSourceService dataSourceService;
    private final OpenSearchSettings settings;

    @Inject
    public TransportCreateDataSourceAction(TransportService transportService, ActionFilters actionFilters, DataSourceServiceImpl dataSourceService, OpenSearchSettings settings) {
        super(NAME, transportService, actionFilters, CreateDataSourceActionRequest::new);
        this.dataSourceService = dataSourceService;
        this.settings = settings;
    }

    protected void doExecute(Task task, CreateDataSourceActionRequest request, ActionListener<CreateDataSourceActionResponse> actionListener) {
        int dataSourceLimit = (Integer)this.settings.getSettingValue(Settings.Key.DATASOURCES_LIMIT);
        if (this.dataSourceService.getDataSourceMetadata(false).size() >= dataSourceLimit) {
            actionListener.onFailure((Exception)new IllegalStateException(String.format("domain concurrent datasources can not exceed %d", dataSourceLimit)));
        } else {
            try {
                DataSourceMetadata dataSourceMetadata = request.getDataSourceMetadata();
                this.dataSourceService.createDataSource(dataSourceMetadata);
                String responseContent = new JsonResponseFormatter<String>(this, JsonResponseFormatter.Style.PRETTY){

                    protected Object buildJsonObject(String response) {
                        return response;
                    }
                }.format((Object)("Created DataSource with name " + dataSourceMetadata.getName()));
                actionListener.onResponse((Object)new CreateDataSourceActionResponse(responseContent));
            }
            catch (Exception e) {
                actionListener.onFailure(e);
            }
        }
    }
}

