/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.time.Duration;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.kstream.EmitStrategy;
import org.apache.kafka.streams.kstream.Windows;
import org.apache.kafka.streams.kstream.internals.MaterializedInternal;
import org.apache.kafka.streams.kstream.internals.MaterializedStoreFactory;
import org.apache.kafka.streams.state.DslWindowParams;
import org.apache.kafka.streams.state.StoreBuilder;
import org.apache.kafka.streams.state.Stores;
import org.apache.kafka.streams.state.WindowBytesStoreSupplier;
import org.apache.kafka.streams.state.WindowStore;

public class WindowStoreMaterializer<K, V>
extends MaterializedStoreFactory<K, V, WindowStore<Bytes, byte[]>> {
    private final Windows<?> windows;
    private final EmitStrategy emitStrategy;
    private final long retentionPeriod;

    public WindowStoreMaterializer(MaterializedInternal<K, V, WindowStore<Bytes, byte[]>> materialized, Windows<?> windows, EmitStrategy emitStrategy) {
        super(materialized);
        this.windows = windows;
        this.emitStrategy = emitStrategy;
        this.retentionPeriod = this.retentionPeriod();
        if (windows.size() + windows.gracePeriodMs() > this.retentionPeriod) {
            throw new IllegalArgumentException("The retention period of the window store " + materialized.storeName() + " must be no smaller than its window size plus the grace period. Got size=[" + windows.size() + "], grace=[" + windows.gracePeriodMs() + "], retention=[" + this.retentionPeriod + "]");
        }
    }

    @Override
    public StoreBuilder<?> builder() {
        WindowBytesStoreSupplier supplier = this.materialized.storeSupplier() == null ? this.dslStoreSuppliers().windowStore(new DslWindowParams(this.materialized.storeName(), Duration.ofMillis(this.retentionPeriod), Duration.ofMillis(this.windows.size()), false, this.emitStrategy, false, true)) : (WindowBytesStoreSupplier)this.materialized.storeSupplier();
        StoreBuilder builder = Stores.timestampedWindowStoreBuilder(supplier, this.materialized.keySerde(), this.materialized.valueSerde());
        if (this.materialized.loggingEnabled()) {
            builder.withLoggingEnabled(this.materialized.logConfig());
        } else {
            builder.withLoggingDisabled();
        }
        if (this.materialized.cachingEnabled()) {
            builder.withCachingEnabled();
        }
        return builder;
    }

    @Override
    public final long retentionPeriod() {
        return this.materialized.retention() != null ? this.materialized.retention().toMillis() : this.windows.size() + this.windows.gracePeriodMs();
    }

    @Override
    public long historyRetention() {
        throw new IllegalStateException("historyRetention is not supported when not a versioned store");
    }

    @Override
    public boolean isWindowStore() {
        return true;
    }

    @Override
    public boolean isVersionedStore() {
        return false;
    }
}

