/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import kafka.network.RequestChannel;
import kafka.server.ClientQuotaManager;
import kafka.server.ControllerMutationQuota;
import kafka.server.QuotaFactory;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.quota.ThrottleCallback;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005e\u0001\u0002\n\u0014\u0001aA\u0001b\b\u0001\u0003\u0002\u0003\u0006I\u0001\t\u0005\tM\u0001\u0011\t\u0011)A\u0005O!AQ\u0007\u0001B\u0001B\u0003%a\u0007C\u0003D\u0001\u0011\u0005A\tC\u0003K\u0001\u0011\u00051\nC\u0003c\u0001\u0011\u00051\rC\u0003q\u0001\u0011%\u0011\u000fC\u0003x\u0001\u0011\u0005\u0001\u0010C\u0004\u0002\u0006\u0001!\t!a\u0002\t\u000f\u00055\u0001\u0001\"\u0001\u0002\u0010!9\u0011Q\u0004\u0001\u0005\u0002\u0005}\u0001bBA\u0013\u0001\u0011\u0005\u0011q\u0005\u0005\b\u0003W\u0001A\u0011AA\u0017\u0011\u001d\ti\u0004\u0001C\u0001\u0003\u007fA\u0011\"a\u0017\u0001#\u0003%\t!!\u0018\t\u000f\u0005M\u0004\u0001\"\u0003\u0002v!9\u00111\u0010\u0001\u0005\u0002\u0005u$\u0001\u0006*fcV,7\u000f\u001e%b]\u0012dWM\u001d%fYB,'O\u0003\u0002\u0015+\u000511/\u001a:wKJT\u0011AF\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0011\u0004\u0005\u0002\u001b;5\t1DC\u0001\u001d\u0003\u0015\u00198-\u00197b\u0013\tq2D\u0001\u0004B]f\u0014VMZ\u0001\u000fe\u0016\fX/Z:u\u0007\"\fgN\\3m!\t\tC%D\u0001#\u0015\t\u0019S#A\u0004oKR<xN]6\n\u0005\u0015\u0012#A\u0004*fcV,7\u000f^\"iC:tW\r\\\u0001\u0007cV|G/Y:\u0011\u0005!\u0012dBA\u00151\u001d\tQsF\u0004\u0002,]5\tAF\u0003\u0002./\u00051AH]8pizJ\u0011AF\u0005\u0003)UI!!M\n\u0002\u0019E+x\u000e^1GC\u000e$xN]=\n\u0005M\"$!D)v_R\fW*\u00198bO\u0016\u00148O\u0003\u00022'\u0005!A/[7f!\t9\u0014)D\u00019\u0015\tI$(A\u0003vi&d7O\u0003\u0002<y\u000511m\\7n_:T!AF\u001f\u000b\u0005yz\u0014AB1qC\u000eDWMC\u0001A\u0003\ry'oZ\u0005\u0003\u0005b\u0012A\u0001V5nK\u00061A(\u001b8jiz\"B!R$I\u0013B\u0011a\tA\u0007\u0002'!)q\u0004\u0002a\u0001A!)a\u0005\u0002a\u0001O!)Q\u0007\u0002a\u0001m\u0005AA\u000f\u001b:piRdW\r\u0006\u0003M\u001fRk\u0006C\u0001\u000eN\u0013\tq5D\u0001\u0003V]&$\b\"\u0002)\u0006\u0001\u0004\t\u0016\u0001D9v_R\fW*\u00198bO\u0016\u0014\bC\u0001$S\u0013\t\u00196C\u0001\nDY&,g\u000e^)v_R\fW*\u00198bO\u0016\u0014\b\"B+\u0006\u0001\u00041\u0016a\u0002:fcV,7\u000f\u001e\t\u0003/js!!\t-\n\u0005e\u0013\u0013A\u0004*fcV,7\u000f^\"iC:tW\r\\\u0005\u00037r\u0013qAU3rk\u0016\u001cHO\u0003\u0002ZE!)a,\u0002a\u0001?\u0006qA\u000f\u001b:piRdW\rV5nK6\u001b\bC\u0001\u000ea\u0013\t\t7DA\u0002J]R\f1\u0002[1oI2,WI\u001d:peR\u0019A\nZ3\t\u000bU3\u0001\u0019\u0001,\t\u000b\u00194\u0001\u0019A4\u0002\u0003\u0015\u0004\"\u0001[7\u000f\u0005%\\gBA\u0016k\u0013\u0005a\u0012B\u00017\u001c\u0003\u001d\u0001\u0018mY6bO\u0016L!A\\8\u0003\u0013QC'o\\<bE2,'B\u00017\u001c\u0003i\u0019XM\u001c3FeJ|'o\u0014:DY>\u001cXmQ8o]\u0016\u001cG/[8o)\u0011a%o];\t\u000bU;\u0001\u0019\u0001,\t\u000bQ<\u0001\u0019A4\u0002\u000b\u0015\u0014(o\u001c:\t\u000bY<\u0001\u0019A0\u0002\u0015QD'o\u001c;uY\u0016l5/A\u000btK:$gi\u001c:xCJ$W\r\u001a*fgB|gn]3\u0015\u00071K(\u0010C\u0003V\u0011\u0001\u0007a\u000bC\u0003|\u0011\u0001\u0007A0\u0001\u0005sKN\u0004xN\\:f!\ri\u0018\u0011A\u0007\u0002}*\u0011qPO\u0001\te\u0016\fX/Z:ug&\u0019\u00111\u0001@\u0003!\u0005\u00137\u000f\u001e:bGR\u0014Vm\u001d9p]N,\u0017!E:f]\u0012l\u0015-\u001f2f)\"\u0014x\u000e\u001e;mKR)A*!\u0003\u0002\f!)Q+\u0003a\u0001-\")10\u0003a\u0001y\u0006I2/\u001a8e%\u0016\u001c\bo\u001c8tK6\u000b\u0017PY3UQJ|G\u000f\u001e7f)\u0015a\u0015\u0011CA\n\u0011\u0015)&\u00021\u0001W\u0011\u001d\t)B\u0003a\u0001\u0003/\tab\u0019:fCR,'+Z:q_:\u001cX\rE\u0003\u001b\u00033yF0C\u0002\u0002\u001cm\u0011\u0011BR;oGRLwN\\\u0019\u0002=M,g\u000eZ#se>\u0014(+Z:q_:\u001cX-T1zE\u0016$\u0006N]8ui2,G#\u0002'\u0002\"\u0005\r\u0002\"B+\f\u0001\u00041\u0006\"\u0002;\f\u0001\u00049\u0017aH7bs\n,'+Z2pe\u0012\fe\u000eZ$fiRC'o\u001c;uY\u0016$\u0016.\\3NgR\u0019q,!\u000b\t\u000bUc\u0001\u0019\u0001,\u0002YM,g\u000e\u001a*fgB|gn]3NCf\u0014W\r\u00165s_R$H.Z,ji\"\u001cuN\u001c;s_2dWM])v_R\fGc\u0002'\u00020\u0005e\u00121\b\u0005\b\u0003ci\u0001\u0019AA\u001a\u0003]\u0019wN\u001c;s_2dWM]'vi\u0006$\u0018n\u001c8Rk>$\u0018\rE\u0002G\u0003kI1!a\u000e\u0014\u0005]\u0019uN\u001c;s_2dWM]'vi\u0006$\u0018n\u001c8Rk>$\u0018\rC\u0003V\u001b\u0001\u0007a\u000bC\u0003|\u001b\u0001\u0007A0\u0001\u000etK:$'+Z:q_:\u001cX-\u0012=f[B$H\u000b\u001b:piRdW\rF\u0004M\u0003\u0003\n\u0019%!\u0012\t\u000bUs\u0001\u0019\u0001,\t\u000bmt\u0001\u0019\u0001?\t\u0013\u0005\u001dc\u0002%AA\u0002\u0005%\u0013AC8o\u0007>l\u0007\u000f\\3uKB)!$a\u0013\u0002P%\u0019\u0011QJ\u000e\u0003\r=\u0003H/[8o!\u0019Q\u0012\u0011DA)\u0019B!\u00111KA,\u001b\t\t)F\u0003\u0002$u%!\u0011\u0011LA+\u0005\u0011\u0019VM\u001c3\u0002IM,g\u000e\u001a*fgB|gn]3Fq\u0016l\u0007\u000f\u001e+ie>$H\u000f\\3%I\u00164\u0017-\u001e7uIM*\"!a\u0018+\t\u0005%\u0013\u0011M\u0016\u0003\u0003G\u0002B!!\u001a\u0002p5\u0011\u0011q\r\u0006\u0005\u0003S\nY'A\u0005v]\u000eDWmY6fI*\u0019\u0011QN\u000e\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002r\u0005\u001d$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006y2/\u001a8e\u000bJ\u0014xN\u001d*fgB|gn]3Fq\u0016l\u0007\u000f\u001e+ie>$H\u000f\\3\u0015\u000b1\u000b9(!\u001f\t\u000bU\u0003\u0002\u0019\u0001,\t\u000bQ\u0004\u0002\u0019A4\u0002=M,g\u000e\u001a(p\u001fB\u0014Vm\u001d9p]N,W\t_3naR$\u0006N]8ui2,Gc\u0001'\u0002\u0000!)Q+\u0005a\u0001-\u0002")
public class RequestHandlerHelper {
    public final RequestChannel kafka$server$RequestHandlerHelper$$requestChannel;
    private final QuotaFactory.QuotaManagers quotas;
    private final Time time;

    public void throttle(ClientQuotaManager quotaManager, RequestChannel.Request request, int throttleTimeMs) {
        ThrottleCallback callback = new ThrottleCallback(this, request){
            private final /* synthetic */ RequestHandlerHelper $outer;
            private final RequestChannel.Request request$1;

            public void startThrottling() {
                this.$outer.kafka$server$RequestHandlerHelper$$requestChannel.startThrottling(this.request$1);
            }

            public void endThrottling() {
                this.$outer.kafka$server$RequestHandlerHelper$$requestChannel.endThrottling(this.request$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.request$1 = request$1;
            }
        };
        quotaManager.throttle(request, callback, throttleTimeMs);
    }

    public void handleError(RequestChannel.Request request, Throwable e) {
        if (e instanceof ClusterAuthorizationException || !request.header().apiKey().clusterAction) {
            this.sendErrorResponseMaybeThrottle(request, e);
            return;
        }
        this.sendErrorResponseExemptThrottle(request, e);
    }

    private void sendErrorOrCloseConnection(RequestChannel.Request request, Throwable error, int throttleMs) {
        Object requestBody = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class));
        AbstractResponse response = requestBody.getErrorResponse(throttleMs, error);
        if (response == null) {
            this.kafka$server$RequestHandlerHelper$$requestChannel.closeConnection(request, requestBody.errorCounts(error));
            return;
        }
        this.kafka$server$RequestHandlerHelper$$requestChannel.sendResponse(request, response, (Option<Function1<Send, BoxedUnit>>)None$.MODULE$);
    }

    public void sendForwardedResponse(RequestChannel.Request request, AbstractResponse response) {
        int controllerThrottleTimeMs = response.throttleTimeMs();
        int requestThrottleTimeMs = this.maybeRecordAndGetThrottleTimeMs(request);
        int appliedThrottleTimeMs = package$.MODULE$.max(controllerThrottleTimeMs, requestThrottleTimeMs);
        this.throttle(this.quotas.request(), request, appliedThrottleTimeMs);
        response.maybeSetThrottleTimeMs(appliedThrottleTimeMs);
        this.kafka$server$RequestHandlerHelper$$requestChannel.sendResponse(request, response, (Option<Function1<Send, BoxedUnit>>)None$.MODULE$);
    }

    public void sendMaybeThrottle(RequestChannel.Request request, AbstractResponse response) {
        int throttleTimeMs = this.maybeRecordAndGetThrottleTimeMs(request);
        if (!request.isForwarded()) {
            this.throttle(this.quotas.request(), request, throttleTimeMs);
        }
        response.maybeSetThrottleTimeMs(throttleTimeMs);
        this.kafka$server$RequestHandlerHelper$$requestChannel.sendResponse(request, response, (Option<Function1<Send, BoxedUnit>>)None$.MODULE$);
    }

    public void sendResponseMaybeThrottle(RequestChannel.Request request, Function1<Object, AbstractResponse> createResponse) {
        int throttleTimeMs = this.maybeRecordAndGetThrottleTimeMs(request);
        if (!request.isForwarded()) {
            this.throttle(this.quotas.request(), request, throttleTimeMs);
        }
        this.kafka$server$RequestHandlerHelper$$requestChannel.sendResponse(request, (AbstractResponse)createResponse.apply((Object)BoxesRunTime.boxToInteger((int)throttleTimeMs)), (Option<Function1<Send, BoxedUnit>>)None$.MODULE$);
    }

    public void sendErrorResponseMaybeThrottle(RequestChannel.Request request, Throwable error) {
        int throttleTimeMs = this.maybeRecordAndGetThrottleTimeMs(request);
        if (error instanceof ClusterAuthorizationException || !request.isForwarded()) {
            this.throttle(this.quotas.request(), request, throttleTimeMs);
        }
        this.sendErrorOrCloseConnection(request, error, throttleTimeMs);
    }

    public int maybeRecordAndGetThrottleTimeMs(RequestChannel.Request request) {
        int throttleTimeMs = this.quotas.request().maybeRecordAndGetThrottleTimeMs(request, this.time.milliseconds());
        request.apiThrottleTimeMs_$eq(throttleTimeMs);
        return throttleTimeMs;
    }

    public void sendResponseMaybeThrottleWithControllerQuota(ControllerMutationQuota controllerMutationQuota, RequestChannel.Request request, AbstractResponse response) {
        int requestThrottleTimeMs;
        long timeMs = this.time.milliseconds();
        int controllerThrottleTimeMs = controllerMutationQuota.throttleTime();
        int maxThrottleTimeMs = Math.max(controllerThrottleTimeMs, requestThrottleTimeMs = this.quotas.request().maybeRecordAndGetThrottleTimeMs(request, timeMs));
        if (maxThrottleTimeMs > 0 && !request.isForwarded()) {
            request.apiThrottleTimeMs_$eq(maxThrottleTimeMs);
            if (controllerThrottleTimeMs > requestThrottleTimeMs) {
                this.throttle(this.quotas.controllerMutation(), request, controllerThrottleTimeMs);
            } else {
                this.throttle(this.quotas.request(), request, requestThrottleTimeMs);
            }
        }
        response.maybeSetThrottleTimeMs(maxThrottleTimeMs);
        this.kafka$server$RequestHandlerHelper$$requestChannel.sendResponse(request, response, (Option<Function1<Send, BoxedUnit>>)None$.MODULE$);
    }

    public void sendResponseExemptThrottle(RequestChannel.Request request, AbstractResponse response, Option<Function1<Send, BoxedUnit>> onComplete) {
        this.quotas.request().maybeRecordExempt(request);
        this.kafka$server$RequestHandlerHelper$$requestChannel.sendResponse(request, response, onComplete);
    }

    public Option<Function1<Send, BoxedUnit>> sendResponseExemptThrottle$default$3() {
        return None$.MODULE$;
    }

    private void sendErrorResponseExemptThrottle(RequestChannel.Request request, Throwable error) {
        this.quotas.request().maybeRecordExempt(request);
        this.sendErrorOrCloseConnection(request, error, 0);
    }

    public void sendNoOpResponseExemptThrottle(RequestChannel.Request request) {
        this.quotas.request().maybeRecordExempt(request);
        this.kafka$server$RequestHandlerHelper$$requestChannel.sendNoOpResponse(request);
    }

    public RequestHandlerHelper(RequestChannel requestChannel, QuotaFactory.QuotaManagers quotas, Time time) {
        this.kafka$server$RequestHandlerHelper$$requestChannel = requestChannel;
        this.quotas = quotas;
        this.time = time;
    }
}

