import { jsx } from 'react/jsx-runtime';
import { useState, useCallback, useEffect } from 'react';
import { Select } from '@grafana/ui';
import '@grafana/data';
import './types.js';

const CatalogSelector = ({ db, inputId, value, onChange }) => {
  const [catalogs, setCatalogs] = useState([]);
  const [isLoading, setIsLoading] = useState(false);
  const loadCatalogs = useCallback(async () => {
    if (!db.catalogs) {
      return;
    }
    setIsLoading(true);
    try {
      const catalogList = await db.catalogs();
      const catalogOptions = catalogList.map((catalog) => ({
        label: catalog,
        value: catalog
      }));
      setCatalogs(catalogOptions);
    } catch (error) {
      console.error("Error loading catalogs:", error);
      setCatalogs([]);
    } finally {
      setIsLoading(false);
    }
  }, [db]);
  useEffect(() => {
    loadCatalogs();
  }, [db, loadCatalogs]);
  const handleChange = (selectable) => {
    onChange((selectable == null ? undefined : selectable.value) || null);
  };
  const selectedValue = catalogs.find((catalog) => catalog.value === value) || null;
  return /* @__PURE__ */ jsx(
    Select,
    {
      inputId,
      options: catalogs,
      value: selectedValue,
      onChange: handleChange,
      isLoading,
      placeholder: "Select catalog",
      isClearable: true,
      allowCustomValue: true,
      menuShouldPortal: true
    }
  );
};

export { CatalogSelector };
//# sourceMappingURL=CatalogSelector.js.map
