/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.auditlog.sink;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Map;
import org.opensearch.action.DocWriteRequest;
import org.opensearch.action.index.IndexRequestBuilder;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.security.auditlog.impl.AuditMessage;
import org.opensearch.security.auditlog.sink.AuditLogSink;
import org.opensearch.security.support.HeaderHelper;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.client.Client;

public abstract class AbstractInternalOpenSearchSink
extends AuditLogSink {
    protected final Client clientProvider;
    private final ThreadPool threadPool;
    protected final ClusterService clusterService;
    private final DocWriteRequest.OpType storeOpType;
    static final Map<String, Object> indexSettings = ImmutableMap.of((Object)"index.number_of_shards", (Object)1, (Object)"index.auto_expand_replicas", (Object)"0-1");

    public AbstractInternalOpenSearchSink(String name, Settings settings, String settingsPrefix, Client clientProvider, ThreadPool threadPool, AuditLogSink fallbackSink, DocWriteRequest.OpType storeOpType, ClusterService clusterService) {
        super(name, settings, settingsPrefix, fallbackSink);
        this.clientProvider = clientProvider;
        this.threadPool = threadPool;
        this.storeOpType = storeOpType;
        this.clusterService = clusterService;
    }

    @Override
    public void close() throws IOException {
    }

    protected abstract boolean createIndexIfAbsent(String var1);

    public boolean doStore(AuditMessage msg, String indexName) {
        if (Boolean.parseBoolean(HeaderHelper.getSafeFromHeader(this.threadPool.getThreadContext(), "_opendistro_security_conf_request"))) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("audit log of audit log will not be executed");
            }
            return true;
        }
        try (ThreadContext.StoredContext ctx = this.threadPool.getThreadContext().stashContext();){
            boolean ok = this.createIndexIfAbsent(indexName);
            if (!ok) {
                this.log.error("Failed to create index {}", (Object)indexName);
                boolean bl = false;
                return bl;
            }
            IndexRequestBuilder irb = ((IndexRequestBuilder)this.clientProvider.prepareIndex(indexName).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).setSource(msg.getAsMap());
            this.threadPool.getThreadContext().putHeader("_opendistro_security_conf_request", "true");
            irb.setTimeout(TimeValue.timeValueMinutes((long)1L));
            if (this.storeOpType != null) {
                irb.setOpType(this.storeOpType);
            }
            irb.execute().actionGet();
            boolean bl = true;
            return bl;
        }
    }
}

