/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.http;

import java.util.List;
import software.amazon.awssdk.crt.http.Http2ConnectionSettingListBuilder;

public class Http2ConnectionSetting {
    private ID id;
    private long value;

    public long getValue() {
        return this.value;
    }

    public ID getId() {
        return this.id;
    }

    public Http2ConnectionSetting(ID id, long value) {
        if (value > 0x100000000L || value < 0L) {
            throw new IllegalArgumentException();
        }
        this.id = id;
        this.value = value;
    }

    public static long[] marshallSettingsForJNI(List<Http2ConnectionSetting> settings) {
        int totalLength = settings.size();
        long[] marshalledSettings = new long[totalLength * 2];
        for (int i = 0; i < totalLength; ++i) {
            marshalledSettings[i * 2] = settings.get((int)i).id.getValue();
            marshalledSettings[i * 2 + 1] = settings.get((int)i).value;
        }
        return marshalledSettings;
    }

    public static Http2ConnectionSettingListBuilder builder() {
        return new Http2ConnectionSettingListBuilder();
    }

    public static enum ID {
        HEADER_TABLE_SIZE(1),
        ENABLE_PUSH(2),
        MAX_CONCURRENT_STREAMS(3),
        INITIAL_WINDOW_SIZE(4),
        MAX_FRAME_SIZE(5),
        MAX_HEADER_LIST_SIZE(6);

        private int settingID;

        private ID(int value) {
            this.settingID = value;
        }

        public int getValue() {
            return this.settingID;
        }
    }
}

