 -*- Mode: makefile-gmake; tab-width: 4; indent-tabs-mode: t -*-
#
# This file is part of the LibreOffice project.
#
# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.
#

$(eval $(call gb_UnpackedTarball_UnpackedTarball,hunspell))

$(eval $(call gb_UnpackedTarball_set_tarball,hunspell,$(HUNSPELL_TARBALL)))

ifeq ($(COM),MSC)
$(eval $(call gb_UnpackedTarball_set_post_action,hunspell,\
	touch src/hunspell/config.h \
))
endif

$(eval $(call gb_UnpackedTarball_set_patchlevel,hunspell,1))

$(eval $(call gb_UnpackedTarball_add_patches,hunspell, \
	external/hunspell/0001-Revert-Remove-autotools-autogenerated-files.patch \
	external/hunspell/0001-unroll-this-a-bit.patch \
	external/hunspell/0001-cppcheck-redundant-c_str.patch \
	external/hunspell/0001-cppcheck-rv-is-reassigned-before-old-value-used.patch \
	external/hunspell/0001-loop-via-iterators.patch \
	external/hunspell/0002-add-a-get_clen_and_captype-varient-that-takes-a-buff.patch \
	external/hunspell/0003-hoist-string-lowering-from-ngram-to-ngsuggest.patch \
	external/hunspell/0004-either-clear-will-be-called-anyway-before-use-or-its.patch \
))

# vim: set noet sw=4 ts=4:
