﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/opensearchserverless/OpenSearchServerless_EXPORTS.h>
#include <aws/opensearchserverless/model/LifecyclePolicyType.h>
#include <aws/opensearchserverless/model/ResourceType.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace OpenSearchServerless {
namespace Model {

/**
 * <p>Error information for an OpenSearch Serverless request.</p><p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/EffectiveLifecyclePolicyDetail">AWS
 * API Reference</a></p>
 */
class EffectiveLifecyclePolicyDetail {
 public:
  AWS_OPENSEARCHSERVERLESS_API EffectiveLifecyclePolicyDetail() = default;
  AWS_OPENSEARCHSERVERLESS_API EffectiveLifecyclePolicyDetail(Aws::Utils::Json::JsonView jsonValue);
  AWS_OPENSEARCHSERVERLESS_API EffectiveLifecyclePolicyDetail& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_OPENSEARCHSERVERLESS_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The type of lifecycle policy.</p>
   */
  inline LifecyclePolicyType GetType() const { return m_type; }
  inline bool TypeHasBeenSet() const { return m_typeHasBeenSet; }
  inline void SetType(LifecyclePolicyType value) {
    m_typeHasBeenSet = true;
    m_type = value;
  }
  inline EffectiveLifecyclePolicyDetail& WithType(LifecyclePolicyType value) {
    SetType(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the OpenSearch Serverless index resource.</p>
   */
  inline const Aws::String& GetResource() const { return m_resource; }
  inline bool ResourceHasBeenSet() const { return m_resourceHasBeenSet; }
  template <typename ResourceT = Aws::String>
  void SetResource(ResourceT&& value) {
    m_resourceHasBeenSet = true;
    m_resource = std::forward<ResourceT>(value);
  }
  template <typename ResourceT = Aws::String>
  EffectiveLifecyclePolicyDetail& WithResource(ResourceT&& value) {
    SetResource(std::forward<ResourceT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the lifecycle policy.</p>
   */
  inline const Aws::String& GetPolicyName() const { return m_policyName; }
  inline bool PolicyNameHasBeenSet() const { return m_policyNameHasBeenSet; }
  template <typename PolicyNameT = Aws::String>
  void SetPolicyName(PolicyNameT&& value) {
    m_policyNameHasBeenSet = true;
    m_policyName = std::forward<PolicyNameT>(value);
  }
  template <typename PolicyNameT = Aws::String>
  EffectiveLifecyclePolicyDetail& WithPolicyName(PolicyNameT&& value) {
    SetPolicyName(std::forward<PolicyNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The type of OpenSearch Serverless resource. Currently, the only supported
   * resource is <code>index</code>.</p>
   */
  inline ResourceType GetResourceType() const { return m_resourceType; }
  inline bool ResourceTypeHasBeenSet() const { return m_resourceTypeHasBeenSet; }
  inline void SetResourceType(ResourceType value) {
    m_resourceTypeHasBeenSet = true;
    m_resourceType = value;
  }
  inline EffectiveLifecyclePolicyDetail& WithResourceType(ResourceType value) {
    SetResourceType(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The minimum number of index retention in days or hours. This is an optional
   * parameter that will return only if it’s set.</p>
   */
  inline const Aws::String& GetRetentionPeriod() const { return m_retentionPeriod; }
  inline bool RetentionPeriodHasBeenSet() const { return m_retentionPeriodHasBeenSet; }
  template <typename RetentionPeriodT = Aws::String>
  void SetRetentionPeriod(RetentionPeriodT&& value) {
    m_retentionPeriodHasBeenSet = true;
    m_retentionPeriod = std::forward<RetentionPeriodT>(value);
  }
  template <typename RetentionPeriodT = Aws::String>
  EffectiveLifecyclePolicyDetail& WithRetentionPeriod(RetentionPeriodT&& value) {
    SetRetentionPeriod(std::forward<RetentionPeriodT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The minimum number of index retention days set. That is an optional param
   * that will return as <code>true</code> if the minimum number of days or hours is
   * not set to a index resource.</p>
   */
  inline bool GetNoMinRetentionPeriod() const { return m_noMinRetentionPeriod; }
  inline bool NoMinRetentionPeriodHasBeenSet() const { return m_noMinRetentionPeriodHasBeenSet; }
  inline void SetNoMinRetentionPeriod(bool value) {
    m_noMinRetentionPeriodHasBeenSet = true;
    m_noMinRetentionPeriod = value;
  }
  inline EffectiveLifecyclePolicyDetail& WithNoMinRetentionPeriod(bool value) {
    SetNoMinRetentionPeriod(value);
    return *this;
  }
  ///@}
 private:
  LifecyclePolicyType m_type{LifecyclePolicyType::NOT_SET};
  bool m_typeHasBeenSet = false;

  Aws::String m_resource;
  bool m_resourceHasBeenSet = false;

  Aws::String m_policyName;
  bool m_policyNameHasBeenSet = false;

  ResourceType m_resourceType{ResourceType::NOT_SET};
  bool m_resourceTypeHasBeenSet = false;

  Aws::String m_retentionPeriod;
  bool m_retentionPeriodHasBeenSet = false;

  bool m_noMinRetentionPeriod{false};
  bool m_noMinRetentionPeriodHasBeenSet = false;
};

}  // namespace Model
}  // namespace OpenSearchServerless
}  // namespace Aws
